
adr.reshape <- function(x, sz) { dim(x) <- sz; x }
adr_reshape <- adr.reshape 

setGeneric("adr_reshape", function(x, sz) {standardGeneric("adr_reshape")})
setMethod("adr_reshape", signature(x = "ANY"), adr.reshape)
setMethod("adr_reshape", signature(x = "array"), adr.reshape)

zeros <- function(...) { dim <- c(...); array(0, dim) }
ones <- function(...) { dim <- c(...); array(1, dim) }
rand <- function(...) { dim <- c(...); array(rnorm(1:prod(dim)), dim) + 0.5 }

safedim <- function(x) if (is.null(dim(x))) length(x) else dim(x);
safemdim <- function(x) { 
    d <- safedim(x)
    if (length(d) == 1) c(d, 1) else d
}
sqdim <- function(x) {
    s <- safedim(x)
    t <- TRUE
    d <- rev(sapply(rev(s), function(k) {
        if (t) {
            if (k == 1) {
                NULL
            } else {
                t <<- FALSE
                k
            }
        } else {
            k
        }
    }))
    if (is.list(d)) {
        d[sapply(d, is.null)] <- NULL
        d <- do.call(c, d)
        if (is.null(d)) {
            d <- 1
        }
    }
    d
}
size <- function(x) if (length(safedim(x)) > 1) safedim(x) else c(safedim(x), 1)
numel <- function(x) prod(safedim(x));

eye <- function(...) { dim <- c(...); if (length(dim) > 1) diag(1, dim[[1]], dim[[2]]) else diag(1, dim[[1]]) }
