adr.repl.mk_householder_elim_vec_lapack <- function(a, n) {
  tolZ = 1e-16
  
  Pk = eye(n)

  k = length(a)

  u = 0
  
  a <- as.matrix(a)
  na = norm(a, '2')

  if (!(k == 1 && isdouble(a)) && na != 0) {
    u = a
    na_rest = norm(a[2:k], '2')

    if (na > tolZ && na_rest != 0) {
      sa1 = sign(Re(a[1]))
      if (sa1 == 0) sa1 = 1
       
      nu = sa1 * na
      
      u[1] = u[1] + nu
      u = u / (a[1] + nu)
    
      sigma = (a[1] + nu) / nu
      
      Pksub = eye(k) - sigma * u %*% Conj(t(u))

      Pk[(n-k+1):n,(n-k+1):n] = Pksub

    }
  }
  list(Pk, u)
# from adimat mk_householder_elim_vec_lapack.m 4801 2014-10-08 12:28:59Z willkomm
}

adr.repl.qr <- function(A) {
    sz <- size(A)
    m <- sz[[1]]
    n <- sz[[2]]
    r = min(m,n)
    if (m <= n && is.double(A)) r = r - 1
    Q <- diag(1, m)
    for (k in 1:r) {
        Pk = adr.repl.mk_householder_elim_vec_lapack(A[k:m,k], m)[[1]]
        Q = Q %*% Pk
        A = Conj(t(Pk)) %*% A
    }
    R = A
    R[lower.tri(R)] = 0
    list(Q, R)
# from adimat_qr.m 3962 2013-10-31 09:47:49Z willkomm
}

adr.repl.norm_p <- function(p) {
    if (p == "2") {
        function(x) {
            if (is.null(dim(x)) || length(dim(x)) == 1 || nrow(x) == 1 || ncol(x) == 1) {
                r <- sqrt(sum(abs(x)^2))
            } else {
                usv <- svd(x, nu = 0, nv = 0)
                r <- usv[['d']][[1]]
            }
            r
        }
    } else if (p == "O") {
        stop("not implemented")
    } else {
        stop("not implemented")
    }
}

## exact copy of convolve from R 3.6.2, but:
##  - no match.args
##  - adr_c instead of c for overloading reasons
##  - mvfft instead of fft
adr_convolve <- function (x, y, conj = TRUE, type = "filter") {
    mymvfft <- function(y, inverse=FALSE) {
        if (is.vector(y)) {
            mvfft(array(y, c(length(y), 1)), inverse=inverse)
        } else {
            mvfft(y, inverse=inverse)
        }
    }
    n <- nrow(x)
    ny <- nrow(y)
    Real <- is.numeric(x) && is.numeric(y)
    if (type == "circular") {
        if (ny != n) {
            stop("length mismatch in convolution")
        }
    }
    else {
        n1 <- ny - 1
        x <- rbind(array(0, c(n1, ncol(x))), x)
        y <- rbind(y, array(0, c(n - 1, ncol(y))))
        n <- nrow(y)
    }
    xf <- mymvfft(x)
    yf <- mymvfft(y)
    if (conj)
        yf <- Conj(yf)
    if (ncol(xf) == 1) {
        xf <- repmat(xf, c(1, ncol(y)))
    }
    if (ncol(yf) == 1) {
        yf <- repmat(yf, c(1, ncol(x)))
    }
    x <- mymvfft(xf * yf, inverse = TRUE)
    if (type == "filter")
        (if (Real) 
             Re(x)
         else x)[-c(1L:n1, (n - n1 + 1L):n),]/n
    else (if (Real) 
              Re(x)
          else x)/n
}
