df_pi <- 0

df_sqrt <- function(ldx, lx) {
    dx <- ldx[[1]]
    x <- lx[[1]]
    y <- sqrt(x)
    divi <- y
    if (any(divi == 0)) {
        divi[divi == 0] <- 1
    }
    list(0.5 * dx / divi, y)
}

df_sin <- function(ldx, lx) {
    dx <- ldx[[1]]
    x <- lx[[1]]
    list(cos(x) * dx, sin(x))
}
df_sinh <-  function(ldx, lx) {
    dx <- ldx[[1]]
    x <- lx[[1]]
    list(cosh(x) * dx, sinh(x))
}
df_asin <-  function(ldx, lx) {
    dx <- ldx[[1]]
    x <- lx[[1]]
    list(dpartial_asin(x) * dx, asin(x))
}
df_asinh <-  function(ldx, lx) {
    dx <- ldx[[1]]
    x <- lx[[1]]
    list(dpartial_asinh(x) * dx, asinh(x))
}

df_cos <- function(dx, x) {
    list(-sin(x[[1]]) * dx[[1]], cos(x[[1]]))
}
df_cosh <- function(dx, x) {
    list(sinh(x[[1]]) * dx[[1]], cosh(x[[1]]))
}
df_acos <- function(dx, x) {
    list(dpartial_acos(x[[1]]) * dx[[1]], acos(x[[1]]))
}
df_acosh <- function(dx, x) {
    list(dpartial_acosh(x[[1]]) * dx[[1]], acosh(x[[1]]))
}

df_tan <- function(dx, x) {
    list(dpartial_tan(x[[1]]) * dx[[1]], tan(x[[1]]))
}
df_tanh <- function(dx, x) {
    list(dpartial_tanh(x[[1]]) * dx[[1]], tanh(x[[1]]))
}
df_atan <- function(dx, x) {
    list(dpartial_atan(x[[1]]) * dx[[1]], atan(x[[1]]))
}
df_atanh <- function(dx, x) {
    list(dpartial_atanh(x[[1]]) * dx[[1]], atanh(x[[1]]))
}

df_atan2 <- function(ldx, lx) {
    dv_q <- ldx[[1]]
    dv_p <- ldx[[2]]
    q <- lx[[1]]
    p <- lx[[2]]
    r <- atan2(q, p)
    divi = q^2 + p^2
    if (any(divi == 0)) {
        divi[divi == 0] = 1
    }
    dv_r <- (dv_q * p - q * dv_p) / divi
    list(dv_r, r)
}

df_exp <- function(dx, x) {
    y <- exp(x[[1]])
    list(y * dx[[1]], y)
}
dpartial_log <- function(x) {
    divi <- x
    if (any(x == 0)) {
        cat(sprintf('Warning: zeros in log argument\n'))
        divi[x == 0] <- 1
    }
    dp <- 1 / divi
    if (any(!is.finite(dp))) {
        cat(sprintf('Warning: non-finite in log partial\n'))
        dp[!is.finite(dp)] <- 0
    }
    dp
}
df_log <- function(dv_x, x) {
       list(dv_x[[1]] * dpartial_log(x[[1]]), log(x[[1]]))
}

df_list <- function(ld, lx) {
    list(ld, lx)
}

df_print <- function(dargs, args, actlist=c()) {
    do.call(print, args)
}

df_cat <- function(dargs, args, actlist=c()) {
    do.call(cat, args)
}

df_show <- function(dargs, args, actlist=c()) {
    do.call(show, args)
}

df_solve <- function(dv_args, args, actlist) {
    A <- args[[1]]
    b <- args[[2]]
    x <- do.call(solve, args)
    nargs <- length(args)
    rhs <- 0
    if (length(actlist) == 2 && actlist[[1]] == 1 && actlist[[2]] == 2) {
        dA <- dv_args[[1]]
        db <- dv_args[[2]]
        dim(db) <- c(numel(x), 1)
        rhs <- db -  dA %*% x
    } else if (length(actlist) == 1 && actlist[[1]] == 1) {
        dA <- dv_args[[1]]
        rhs <- dA %*% -x
    } else if (length(actlist) == 1 && actlist[[1]] == 2) {
        db <- dv_args[[1]]
        dim(db) <- c(numel(x), 1)
        rhs <- db
    } else {
        logMessage('adr:df_solve:noindep', logLError, paste0('Cannot diff. solve w.r.t. independent list ', paste0(actlist, collapse=', ')))
    }
    dx <- do.call(solve, c(list(A, rhs, args[2:nargs])))
    list(dx, x)
}


df_sum <- function(dargs, args, na.rm = FALSE) {
    if (na.rm) {
        rng <- 1:length(dargs)
        lapply(rng, function(ind) {
            nal <- which(is.na(args[[ind]]))
            if (length(nal) > 0) {
                dargs[[ind]][nal] <<- 0
            }
        })
    }
    dx <- do.call(sum, append(dargs, list(na.rm = na.rm)))
    x <- do.call(sum, append(args, list(na.rm = na.rm)))
    list(dx, x)
}

df_t <- function(dA, A, ...) {
    list(t(dA[[1]]), t(A[[1]]))
}

df_rev <- function(df_x, x, ...) {
    list(rev(df_x[[1]]), rev(x[[1]]))
}

df_range <- function(df_x, x, ...) {
    wm <- which.min(x[[1]])
    wM <- which.max(x[[1]])
    a <- c(wm,wM)
    list(df_x[[1]][a], x[[1]][a])
}

df_cbind <- function(dv, v, actlist) {
    r <- do.call(cbind, v)
    isdpl <- if (is.null(names(v))) FALSE else names(v) == 'deparse.level'
    dvf <- lapply(v[!isdpl], d_zeros)
#    dvf <- rep(list(0), length(v))
#    for(i in 1:length(v)) {
#        dvf[[i]] = d_zeros(v[[i]])
                                        #    }
#    show(list(df_cbind.dv=dv, v = v, actlist=actlist,sel=!sapply(dv, is.null)))
    dvf[actlist] <- dv[!sapply(dv, is.null)]
    dr <- do.call(cbind, dvf)
    list(dr, r)
}

df_rbind <- function(dv, v, actlist) {
    r <- do.call(rbind, v)
    dvf <- lapply(v, d_zeros)
#    show(list(rbind.dv=dv, v = v))
    dvf[actlist] <- dv[!sapply(dv, is.null)]
    dr <- do.call(rbind, dvf)
    list(dr, r)
}

df_diff <- function(dA, A, ...) {
    dx <- do.call(diff, append(list(dA[[1]]), A[-1]))
    x <- do.call(diff, A)
    list(dx, x)
}

df_convolve <- function(dx, x, actlist) {
    r <- do.call(convolve, x)
    dr <- 0
    if (1 %in% actlist) {
        dr <- dr + do.call(convolve, append(dx[1], x[-1]))
    }
    if (2 %in% actlist) {
        dr <- dr + do.call(convolve, append(append(x[1], dx[2]), x[c(-1,-2)]))
    }
    list(dr, r)
}

df_fft <- function(dA, A, ...) {
    dx <- do.call(fft, append(list(dA[[1]]), A[-1]))
    x <- do.call(fft, A)
    list(dx, x)
}

df_mvfft <- function(dA, A, ...) {
    dx <- do.call(mvfft, append(list(dA[[1]]), A[-1]))
    x <- do.call(mvfft, A)
    list(dx, x)
}

df_aperm <- function(dA, A, ...) {
    dx <- do.call(aperm, append(list(dA[[1]]), A[-1]))
    x <- do.call(aperm, A)
    list(dx, x)
}

partial_kronecker_l <- function(x, y) {
    tx <- array(1:length(x), dim(x))
    ty <- array(1, dim(y))
    to <- kronecker(tx, ty)
    
    js <- sort(c(to), index.return=TRUE)
    partial <- Matrix::sparseMatrix(i=js$ix, j=js$x, x=y, dims=c(length(to), length(y)))
    
    partial
}

partial_kronecker_r <- function(x, y) {
    tx <- array(1, dim(x))
    ty <- array(1:length(y), dim(y))
    to <- kronecker(tx, ty)
    
    js <- sort(c(to), index.return=TRUE)
    partial <- Matrix::sparseMatrix(i=js$ix, j=js$x, x=x, dims=c(length(to), length(y)))
    
    partial
}

df_kronecker <- function(dx, x, actlist) {
    dz <- 0
    iind <- 1
    if (1 %in% actlist) {
        dp <- dx[[iind]]
        dim(dp) <- c(length(dp), 1)
        P <- partial_kronecker_l(x[[1]], x[[2]])
        dz <- dz + P %*% dp
        iind <- iind+1
    }
    if (2 %in% actlist) {
        dp <- dx[[iind]]
        dim(dp) <- c(length(dp), 1)
        P <- partial_kronecker_r(x[[1]], x[[2]])
        dz <- dz + P %*% dp
        iind <- iind+1
    }
    z <- do.call(kronecker, x)
    list(dz, z)
}


dop_plus <- function(da, a, db, b)     da + db
dop_plus_left <- function(a, db, b)         db + d_zeros(a)
dop_plus_right <- function(da, a, b)        da + d_zeros(b)

dop_minus <- function(da, a, db, b)    da - db
dop_minus_left <- function(a, db, b)       -db + d_zeros(a)
dop_minus_right <- function(da, a, b)       da + d_zeros(b)

dop_mult <- function(da, a, db, b)     da * b + a * db
dop_mult_left <- function(a, db, b)    a * db
dop_mult_right <- function(da, a, b)   da * b

dop_mmult <- function(da, a, db, b)    adr_mtimes(da, b) + adr_mtimes(a, db)
dop_mmult_left <- function(a, db, b)   adr_mtimes(a, db)
dop_mmult_right <- function(da, a, b)  adr_mtimes(da, b)

dop_mod <- function(da, a, db, b)       da - db * floor(a/b)
dop_mod_left <- function(a, db, b)     -db * floor(a/b)
dop_mod_right <- function(da, a, b)     da

dop_idiv <- function(da, a, db, b)      0*da + 0*db
dop_idiv_left <- function(a, db, b)     0*db
dop_idiv_right <- function(da, a, b)    0*da

dop_colon <- function(da, a, db, b)       repmat(da, size(a:b))
dop_colon_left <- function(a, db, b)      repmat(0*db, size(a:b))
dop_colon_right <- function(da, a, b)     repmat(da, size(a:b))

dop_div <- function(da, a, db, b) {
    dp2 <- -a / b^2
    da / b + dp2 * db
}
dop_div_right <- function(da, a, b) {
    da / b
}
dop_div_left <- function(a, db, b) {
    dp2 <- -a / b^2
    dp2 * db
}

dop_pow <- function(da, a, db, b)    {
    dp1 <- b * a^(b-1)
    dp2 <- log(a) * a^b
    dp1 * da + dp2 * db
}
dop_pow_right <- function(da, a, b)  {
    dp1 <- b * a^(b-1)
    dp1 * da
}
dop_pow_left <- function(a, db, b)  {
    dp2 <- log(a) * a^b
    dp2 * db
}

df_qr <- function(ldx, lx, actlist) {
    r <- qr(lx[[1]])
    dr <- d(adr.repl.qr)(ldx, lx)
    list(dr[[1]], r)
}
df_qr.Q <- function(ldx, lx, actlist) {
    list(ldx[[1]][[1]], do.call(qr.Q, lx))
}
df_qr.R <- function(dargs, args, actlist) {
    list(dargs[[1]][[2]], do.call(qr.R, args))
}
df_qr.qy <- function(ldx, lx, actlist) {
    qr <- lx[[1]]
    y <- lx[[2]]
    list(
    (if (any(actlist == 1)) ldx[['qr']][[1]] %*% y else 0) +
     (if (any(actlist == 2)) qr.Q(qr) %*% ldx[['y']] else 0),
    qr.qy(qr, y))
}
df_qr.qty <- function(ldx, lx, actlist) {
    qr <- lx[[1]]
    y <- lx[[2]]
    list(
    (if (any(actlist == 1)) t(ldx[['qr']][[1]]) %*% y else 0) +
     (if (any(actlist == 2)) t(qr.Q(qr)) %*% ldx[['y']] else 0),
    qr.qty(qr, y))
}

df_as.double <- function(ldx, lx, actlist) {
    dx <- ldx[[1]]
    x <- lx[[1]]
    list(as.double(dx), as.double(x))
}

df_as.matrix <- function(ldx, lx, actlist) {
    dx <- do.call(as.matrix, append(list(ldx[[1]]), lx[-1]))
    x <- do.call(as.matrix, lx)
    list(dx, x)
}

df_abs <- function(ldx, lx) {
    dx <- ldx[[1]]
    x <- lx[[1]]
    df_abs.fabs <- function(d1, d2) { sqrt(d1^2 + d2^2) }
    d(df_abs.fabs)(list(Re(dx), Im(dx)), list(Re(x), Im(x)))
}

df_norm <- function(dargs, args) {
    x <- args[[1]]
    if (length(args) > 1) {
        p <- args[[2]]
    } else {
        p <- "2"
    }
    df_norm.norm_p_repl <- adr.repl.norm_p(p)
    dr <- d(df_norm.norm_p_repl)(dargs, list(x, p))
}

df_Conj <- function(ldx, lx) {
    dx <- ldx[[1]]
    x <- lx[[1]]
    list(Conj(dx), Conj(x))
}

df_diag <- function(ldx, lx, actlist) {
    list(do.call(diag, append(ldx, lx[-1])), do.call(diag, lx))
}

df_svd <- function(ldx, lx, actlist) {
    dv_x <- ldx[[1]]
    x <- lx[[1]]
    z <- svd(x, dim(x)[[1]], dim(x)[[2]])
    d_usv <- colSums(z$u * (dv_x %*% z$v))
    dz <- list(d = d_usv, u = 0, v = 0)
    if (is.null(lx$nu)) {
        lx$nu <- min(dim(x))
    }
    if (is.null(lx$nv)) {
        lx$nv <- min(dim(x))
    }
    z$u <- z$u[,1:lx$nu]
    z$v <- z$v[,1:lx$nv]
    if (lx$nu != 0 || lx$nv != 0) {
        # ...
    }
    list(dz, z)
}

df_pmax <- function(ldx, lx, actlist) {
    r <- do.call(pmax, lx)

    na.rm <- lx$na.rm
    lx <- lx[-length(lx)]

    lx <- lapply(lx, function(a) {
        if (length(a) <= length(r)) rep(a, length.out=length(r)) else a
    })
    ldx <- lapply(ldx, function(a) {
        if (length(a) <= length(r)) rep(a, length.out=length(r)) else a
    })

    wi <- sapply(1:length(r), function(k) {
        ei <- sapply(lx, function(a) { a[[k]] })
        which.max(ei)
    })
    dr <- d_zeros(r)
    for (k in 1:length(actlist)) {
        aind <- actlist[[k]]
        dr[wi == aind] = ldx[[k]][wi == aind]
    }
    list(dr, r)
}

df_pmin <- function(ldx, lx, actlist) {
    r <- do.call(pmin, lx)

    na.rm <- lx$na.rm
    lx <- lx[-length(lx)]

    lx <- lapply(lx, function(a) {
        if (length(a) <= length(r)) rep(a, length.out=length(r)) else a
    })
    ldx <- lapply(ldx, function(a) {
        if (length(a) <= length(r)) rep(a, length.out=length(r)) else a
    })

    wi <- sapply(1:length(r), function(k) {
        ei <- sapply(lx, function(a) { a[[k]] })
        which.min(ei)
    })
    dr <- d_zeros(r)
    for (k in 1:length(actlist)) {
        aind <- actlist[[k]]
        dr[wi == aind] = ldx[[k]][wi == aind]
    }
    list(dr, r)
}

dpartial_sqrt <- function(x) {
    divi <- sqrt(x)
    divi[which(divi == 0)] = 1
    0.5 / divi
}

dpartial_tan <- function(x) {
    divi <- cos(x)^2
    divi[which(divi == 0)] = 1
    1 / divi
}

dpartial_tanh <- function(x) {
    divi <- cosh(x)^2
    divi[which(divi == 0)] = 1
    1 / divi
}

dpartial_asin <- function(x) {
    divi <- cos(asin(x))
    divi[which(divi == 0)] = 1
    1 / divi
}

dpartial_acos <- function(x) {
    divi <- -sin(acos(x))
    divi[which(divi == 0)] = 1
    1 / divi
}

dpartial_atan <- function(x) {
    cos(atan(x))^2
}

dpartial_asinh <- function(x) {
    divi <- cosh(asinh(x))
    divi[which(divi == 0)] = 1
    1 / divi
}

dpartial_acosh <- function(x) {
    divi <- sinh(acosh(x))
    divi[which(divi == 0)] = 1
    1 / divi
}

dpartial_atanh <- function(x) {
    cosh(atanh(x))^2
}

df_append <- function(dargs, args) {
    list(
        append(dargs[[1]], dargs[[2]]),
        append(args[[1]], args[[2]])
    )
}

df_lapply <- function(dargs, args) {
    l <- args[[1]]
    f <- args[[2]]
    df <- d(f, 1)
    dl <- lapply(1:length(l), function(i) {
        df(dargs[[1]][i], args[[1]][i])
    })
    
#    show('dl')
#    show(dl)
    ldv <- lapply(dl, function(li) {
        li[[1]]
    })
    lv <- lapply(dl, function(li) {
        li[[2]]
    })
    names(ldv) <- names(dargs)
    names(lv) <- names(args)
#    show('ldv')
#    show(ldv)
#    show('lv')
#    show(lv)
    list(df = ldv, f = lv)
}

df_sapply <- function(dargs, args) {
    l <- args[[1]]
    f <- args[[2]]
    df <- d(f, 1)
    dl <- lapply(1:length(l), function(i) {
        df(dargs[[1]][i], args[[1]][i])
    })
    
#    show('dl')
#    show(dl)
    ldv <- sapply(dl, function(li) {
        li[[1]]
    })
    lv <- sapply(dl, function(li) {
        li[[2]]
    })
    if (!is.null(args$USE.NAMES) && args$USE.NAMES) {
        names(ldv) <- names(dargs)
        names(lv) <- names(args)
    }
#    show('ldv')
#    show(ldv)
#    show('lv')
#    show(lv)
    list(df = ldv, f = lv)
}

df_array <- function(ldx, lx, actlist) {
    if (1 %in% actlist) {
        de <- ldx[[1]]
    } else {
        de <- d_zeros(lx[[1]])
    }
    ladx <- lx
    ladx[[1]] <- de
    list(df = do.call(array, ladx), f = do.call(array, lx))
}

df_c <- function(ldx, lx, actlist) {
    list(df = do.call(c, ldx), f = do.call(c, lx))
}

dpartial_pnorm <- function(lx) {
    dp <- dnorm(lx$q, lx$mean, lx$sd)
    if (lx$log.p) {
        p <- pnorm(lx$q, lx$mean, lx$sd)
        dp <- dp / p
    }
    dp
}

df_pnorm <- function(ldx, lx) {
    dp <- dpartial_pnorm(lx)
    list(dp * ldx[[1]], do.call(pnorm, lx))
}

dpartial_dnorm <- function(lx) {
    dp <- -(lx$x - lx$mean) * dnorm(lx$x, lx$mean, lx$sd) / (lx$sd^2)
    if (lx$log) {
        p <- dnorm(lx$x, lx$mean, lx$sd)
        dp <- dp / p
    }
    dp
}

df_dnorm <- function(ldx, lx) {
    show(lx)
    dp <- dpartial_dnorm(lx)
    list(dp * ldx[[1]], do.call(dnorm, lx))
}

df_adr_reshape <- df_adr.reshape <- function(ldx, lx) {
    list(adr.reshape(ldx[[1]], lx[[2]]), adr.reshape(lx[[1]], lx[[2]]))
}

df_zeros <- function(x) {
    list(d_zeros(x), x)
}

df_is.null <-
df_is.complex <-
df_is.double <-
df_is.numeric <-
df_is.array <-
df_is.matrix <-
df_is.function <-
df_is.list <- function(x) {
    list(0, x)
}

df_rep <- function(ldx, lx) {
    list(do.call(rep, append(ldx[1], lx[-1])), do.call(rep, lx))
}

df_rep.int <- function(ldx, lx) {
    dx <- ldx[[1]]
    x <- lx[[1]]
    n <- lx[[2]]
    list(rep(dx, n), rep.int(x, n))
}

df_Re <-  function(ldx, lx) {
    dx <- ldx[[1]]
    x <- lx[[1]]
    list(Re(dx), Re(x))
}

df_Im <-  function(ldx, lx) {
    dx <- ldx[[1]]
    x <- lx[[1]]
    list(Im(dx), Im(x))
}
