adr_store_mem <- local({
  stack <- list(0)
  ptr <- 0
  function(mode, val) {
    if (mode == 0) {
                                        # restore
#        if (ptr <= 0) {
#            stop('stack underrun')
#        }
        res <- stack[[ptr]]
        stack[[ptr]] <<- 0
        ptr <<- ptr - 1
    } else if (mode == 1) {
                                        # store
        res <- 0
        ptr <<- ptr + 1
        if (ptr > length(stack))
            stack <<- append(stack, rep(list(0), length(stack)))
        stack[ptr] <<- list(val)
    } else if (mode == 2) {
                                        # number of items on stack
        res <- ptr
    } else if (mode == 3) {
                                        # actual size of stack
        res <- length(stack)
    } else if (mode == 7) {
                                        # full stack
        res <- stack
    } else if (mode == 8) {
                                        # clear stack
        stack <<- list(0)
        ptr <<- 0
        res <- 0
    }
    res
  }
})

adr_store <- adr_store_mem

adr_pop <- function() {
    adr_store(0)
}

adr_push <- function(x) {
  xexpr <- substitute(x)
  sym <- deparse(xexpr)
  env <- parent.frame()
  if (is.call(xexpr) || exists(sym, env))
      adr_store(1, x)
  else
      adr_store(1, NULL)
}

adr_push_index <- function(x, ...) {
    adr_push(safedim(x))
    adr_push(x[...])
}

adr_pop_index <- function(x, ...) {
    sarr <- adr_pop()
    sdim <- adr_pop()
#    show(list(adr_pop_index.dimx=safedim(x), pdim=safedim(sarr), sdim=sdim))
    x[...] <- sarr
    adr_reshape(x[1:prod(sdim)], sdim)
}

adj_zeros <- function(x) {
    am <- adrGetOption('a_zeros-mode', 0)
#    show(list(adj_zeros.adjmode=am, x=class(x)))
    if (am == 0) {
        d_zeros(x)
    } else if (am == 1) {
        d_zeros_scalar(x)
    } else if (am == 2) {
        d_zeros_vector(x)
    } else if (am == 12) {
        d_zeros_adtay(x)
    } else {
        stop(paste('adj_zeros: a_zeros-mode', am, 'not implemented'))
    }
}

a_zeros <- function(x) {
  xexpr <- substitute(x)
  sym <- deparse(xexpr)
  env <- parent.frame()
#  show(list(a_zeros.x=xexpr))
  if (is.call(xexpr) || exists(sym, env)) {
#      show(list(a_zeros.x=class(x)))
      adj_zeros(x)
  } else
      adj_zeros(0)
}

a_zeros_index <- function(adj, x, ...) {
    adj[...] <- a_zeros(adj[...])
    sdim <- safedim(x)
    adr_reshape(adj[1:prod(sdim)], sdim)
}

adr_adjsum <- function(a, b) {
    ##    show(list(adjsum.a = a, adjsum.b = b))
    if (is.list(a)) {
        if (length(a)>0) {
            r <- lapply(1:length(a), function(i) { adr_adjsum(a[[i]], b[[i]]) })
        } else {
            r <- a
        }
        names(r) <- names(a)
        r
    } else if (is.character(b) || is.function(b)) {
        a
    } else {
#        show(list(a=class(a),b=class(b)))
#        show(list(adjsum.a = a, adjsum.b = b))
        ## if (any(is.na(a)))
        ##     stop('na in adjoint a')
        ## if (any(is.na(b)))
        ##     stop('na in adjoint b')
        a + b
    }
}

adr_adjselect <- function(arr, i, incr) {
    if (class(incr) == 'advec' && class(arr) != 'advec' && class(arr) != 'list') {
        darr <- d_zeros(arr)
        dim(darr@data) <- c(prod(darr@sz), darr@ndd)
        darr@data <- repmat(c(arr), c(1, darr@ndd))
        dim(darr@data) <- c(darr@sz, darr@ndd)
        arr <- darr
    }
    arr[[i]] <- incr
    arr
}

adr_adjmultr <- function(val, a, b) {
    if (numel(val) == 1) {
        res <- sum(a * b)
    } else {
        adr_reshape(t(a) %*% b, safedim(val))
    }
}

adr_adjmultl <- function(val, a, b) {
    if (numel(val) == 1) {
        res <- sum(a * b)
    } else {
        adr_reshape(a %*% t(b), safedim(val))
    }
}

adr_adjred <- function(val, a) {
    if (is.list(val)) {
        a
    } else if (length(val) == 1) {
        res <- a
        dim(res) <- length(res)
        res <- sum(res)
    } else {
        a
    }
}

partial_subsref <- function(val, ...) {
    inds = list(...)
    tobj = array(1:numel(val), safedim(val))
    sel = tobj[...]
    nin = numel(val)
    nout = numel(sel)
    J <- if (nout > 0 && nin > 0)
             sparseMatrix(i = 1:nout, j = c(sel), x = 1, dims = c(nout, nin))
         else
             matrix(0, nout, nin)
}

adr.adjTimesP <- function(val, adj, P) {
    dim(adj) = c(1, numel(adj))
    if (is.numeric(adj)) {
        r <- as.matrix(adj %*% P)
    } else {
        r <- as.matrix(Re(adj) %*% P) + 1i * as.matrix((Im(adj) %*% P))
    }
    dim(r) = safedim(val)
    r
}

adr_adjsubsref <- function(val, a, ...) {
    if (is.list(a)) {
        r <- a_zeros(val)
        r[...] <- a
    } else {
        P <- partial_subsref(val, ...)
        r <- adr.adjTimesP(val, a, P)
    }
    r
}

partial_subsasgn <- function(obj, val, ...) {
    testobj = array(0, safedim(obj))
#    show(list(partial_subsasgn.inds=list(...),obj=obj,val=val))
    testobj[...] = array(1:numel(val), safedim(val))
    nout = numel(testobj)
    nin = numel(val)
    J <- if (nout > 0 && nin > 0)
             sparseMatrix(i = which(testobj != 0),
                          j = testobj[testobj != 0],
                          x = 1,
                          dims = c(nout, nin))
         else
             matrix(0, nout, nin)
}

adr_adjsubsasgn <- function(adj, val, ...) {
#    show(list(adr_adjsubsasgn.inds=list(...),adj=adj,val=val))
    if (is.list(adj)) {
        r <- adj[...]
    } else {
        P <- partial_subsasgn(adj, val, ...)
        r <- adr.adjTimesP(val, adj, P)
    }
    r
}

a_sum <- function(adj, args, actlist) {
    whichna.rm = which(names(args) == 'na.rm')
    if (length(whichna.rm)) {
        na.rm.actlistpos = which(actlist == whichna.rm)
        if (length(na.rm.actlistpos)) {
            actlist = actlist[-na.rm.actlistpos]
        }
    }
    narm <- args[['na.rm']]
    adjsums <- lapply(actlist, function(ai) {
        val <- args[[ai]]
        P <- val*0 + 1
        if (!is.null(narm) && narm) {
            P[is.na(val)] <- 0
        }
#        show(list(a_sum.ai=ai, val=val, dim.P=dim(P), dim.val=dim(val), dim.adj=dim(adj)))
        r <- repmat(adj, safedim(P)) * P
#        show(list(a_sum.ai=ai, r=r, P=P))
        r
    })
    list(adj = append(adjsums, list(na.rm = a_zeros(0))))
}
ret_sum <- a_sum


a_sqrt <- function(adj, args, actlist) {
    list(adj = list(adj * dpartial_sqrt(args[[1]])))
}
ret_sqrt <- a_sqrt

a_abs <- function(adj, x) {
    adjfunc <- adj(function(x,y) sqrt(x^2 + y^2))
    ar <- adjfunc(Re(adj), list(Re(x), Im(x)), 1:2)
    ar$adj$x - 1i * ar$adj$y
}

partial_crbind <- function(handle, args, ai) {
    zargs <- lapply(args, function(x) {
        array(0, safedim(x))
    })
    zargs[[ai]] <- array(1, safedim(args[[ai]]))
    res <- do.call(handle, zargs)

    is <- which(res == 1)
    js <- 1:numel(args[[ai]])
    if (length(args[[ai]]) == 1) {
        js <- rep(1, length(is))
    }
    p2 <- sparseMatrix(i = is, j = js, x = 1, dims = c(numel(res), numel(args[[ai]])))
}

rec_cbind <- function(...) {
    args <- list(...)
    res <- do.call(cbind, args)
    res
}

a_cbind <- function(at, args, actlist) {
#    show(list(a_cbind.adj=adj,args=args,actlist=actlist))
    ar <- list()
    dim(at) <- c(1, length(at))
    for (ai in actlist) {
        P <- partial_crbind(cbind, args, ai)
#        show(list(ai=ai,adj=adj,at=at, P=P))
#        show(list(at=class(at), P=class(P)))
#        show(list(at=dim(at), P=dim(P)))

#        adji <- at %*% P
#        dim(adji) <- dim(args[[ai]])
#        show(list(adji=adji))

        adji <- adr.adjTimesP(args[[ai]], at, P)
        ar <- append(ar, list(adji))
    }
#    show(list(ar=ar))
    list(adj=ar)
}

ret_cbind <- a_cbind

rec_rbind <- function(...) {
    args <- list(...)
    res <- do.call(rbind, args)
    res
}

a_rbind <- function(at, args, actlist) {
    ar <- list()
    at
    dim(at) <- c(1, length(at))
    for (ai in actlist) {
        P <- partial_crbind(rbind, args, ai)
        adji <- adr.adjTimesP(args[[ai]], at, P)
        ar <- append(ar, adji)
    }
    list(adj=ar)
}

ret_rbind <- a_rbind

a_diff <- function(adj, x, lag = 1, differences = 1) {
    if (differences > 1) {
        adj <- a_diff(adj, x, lag, differences - 1)
    }
    # if (differences == 1) {
    zelem <- a_zeros(array(0, c(lag, ncol(adj))))
    adj1 <- rbind(zelem, adj)
    adj2 <- rbind(adj, zelem)
    adj1 - adj2
}

a_adr_norm1 <- function(x, a_z) {
    adj(adr.repl.norm_p("2"))(a_z, list(x))$adj$x
}
a_adr_norm2 <- function(x, p, a_z) {
    adj(adr.repl.norm_p(p))(a_z, list(x))$adj$x
}

a_svd_1 <- function(adj, x, nu = 0, nv = 0) {
    z <- svd(x, dim(x)[[1]], dim(x)[[2]])
    adj <- diag(adj$d)
    z$u %*% adj %*% t(z$v)
}

rec_as.matrix <- function(x) {
    as.matrix(x)
}
a_as.matrix <- function(adj, lx, al) {
    dim(adj) <- safedim(lx[[1]])
    list(adj = list(adj), f = lx)
}
ret_as.matrix <- a_as.matrix

rec_list <- function(...) {
    list(...)
}
a_list <- function(adj, args, which) {
#    show(list(a_list.adj = adj, which = which))
    list(adj = adj[which])
}
ret_list <- a_list

rec_solve <- function(x, y, ...) {
    z <- solve(x, y, ...)
    adr_push(z)
    adr_push(list(...))
    z
}
a_solve <- function(a_z, args, actlist) {
    oargs <- adr_pop()
    z <- adr_pop()
    a <- args[[1]]
    b <- args[[2]]
    adim <- dim(a)
    m <- adim[[1]]; n <- adim[[2]]
    if (m == 1 && n == 1) {
        a_b <- adr_adjred(b, a_z / a);
        a_a <- adr_adjred(a, -(a_z * z) / a);
    } else {
        a_b <- do.call(solve, append(list(t(a), a_z), oargs))
        a_a <- do.call(solve, append(list(t(a), -(a_z %*% t(z))), oargs))
    }
    a_res <- list(a = a_a, b = a_b)
    list(adj = a_res[actlist], f = z)
}
ret_solve <- a_solve

a_diag <- function(adj, x, nu = 0, nv = 0) {
    if (is.matrix(x) || length(safedim(x)) > 1) {
        nu <- safedim(x)[[1]]
        nv <- safedim(x)[[2]]
        diag(adj)
    } else {
        if (nu == 0) nu <- safedim(adj)[[1]]
        if (nv == 0) nv <- safedim(adj)[[2]]
        diag(adj[1:nu,1:nv])
    }
}
ret <- a_diag

rec_convolve <- function(x, y, ...) {
    convolve(x, y, ...)
}
a_convolve <- ret_convolve <- function(ac, args, actlist, ...) {
    x <- args$x
    y <- args$y
    conj <- args$conj
    type <- args$type
    adjlist <- list()
    if (1 %in% actlist) {
        ax <- convolve(ac, rev(y), conj, type)
        ax <- ax[length(y):(length(x) + length(y) - 1)]
        adjlist <- append(adjlist, list(x=ax))
    }
    if (2 %in% actlist) {
        ay <- convolve(x, ac, conj, type)
        ay <- ay[length(x):(length(x) + length(y) - 1)]
        adjlist <- append(adjlist, list(y=ay))
    }
    list(adj=adjlist)
}

a_fft <- function(adj, k, x, inverse = FALSE) {
    fft(adj, inverse=inverse)
}

rec_mvfft <- mvfft

ret_mvfft <- a_mvfft <- function(adj, args, actlist) {
    x <- args[[1]]
    inv <- args$inverse
    list(adj=list(x=mvfft(adj, inverse=inv)))
}

rec_aperm <- aperm

ret_aperm <- a_aperm <- function(adj, args, actlist) {
    perm <- args[[2]]
    iperm <- rep(0, length(dim(adj)))
    iperm[perm] <- 1:length(dim(adj))
    list(adj=list(x=aperm(adj, iperm)))
}

rec_kronecker <- kronecker

ret_kronecker <- a_kronecker <- function(ax, x, actlist) {
    dz <- 0
    dim(ax) <- c(1, length(ax))
    al <- list()
    if (1 %in% actlist) {
        a1 <- ax %*% partial_kronecker_l(x[[1]], x[[2]])
        dim(a1) <- dim(x[[1]])
        al <- append(al, list(X=a1))
    }
    if (2 %in% actlist) {
        a1 <- ax %*% partial_kronecker_r(x[[1]], x[[2]])
        dim(a1) <- dim(x[[2]])
        al <- append(al, list(Y=a1))
    }
    ##    show(list(al=al))
    list(adj=al)
}
    
rec_rev <- function(...) { rev(...) }
a_rev   <- function(a, args, actlist) {
    list(adj = list(adr.reshape(rev(a), safedim(args[[1]]))))
}
ret_rev <- a_rev

ret_sin <- a_sin <- function(a, args, actlist) {
    list(adj = list(cos(args[[1]]) * a), sin(args[[1]]))
}
ret_cos <- a_cos <- function(a, args, actlist) {
    list(adj = list(-sin(args[[1]]) * a), cos(args[[1]]))
}
ret_tan <- a_tan <- function(a, args, actlist) {
    list(adj = list(dpartial_tan(args[[1]]) * a), tan(args[[1]]))
}

ret_sinh <- a_sinh <- function(a, args, actlist) {
    list(adj = list(cosh(args[[1]]) * a), sinh(args[[1]]))
}
ret_cosh <- a_cosh <- function(a, args, actlist) {
    list(adj = list(sinh(args[[1]]) * a), cosh(args[[1]]))
}
ret_tanh <- a_tanh <- function(a, args, actlist) {
    list(adj = list(dpartial_tanh(args[[1]]) * a), tanh(args[[1]]))
}

ret_asin <- a_asin <- function(a, args, actlist) {
    list(adj = list(dpartial_asin(args[[1]]) * a), asin(args[[1]]))
}
ret_acos <- a_acos <- function(a, args, actlist) {
    list(adj = list(dpartial_acos(args[[1]]) * a), acos(args[[1]]))
}
ret_atan <- a_atan <- function(a, args, actlist) {
    list(adj = list(dpartial_atan(args[[1]]) * a), atan(args[[1]]))
}

ret_asinh <- a_asinh <- function(a, args, actlist) {
    list(adj = list(dpartial_asinh(args[[1]]) * a), asinh(args[[1]]))
}
ret_acosh <- a_acosh <- function(a, args, actlist) {
    list(adj = list(dpartial_acosh(args[[1]]) * a), acosh(args[[1]]))
}
ret_atanh <- a_atanh <- function(a, args, actlist) {
    list(adj = list(dpartial_atanh(args[[1]]) * a), atanh(args[[1]]))
}


ret_exp <- a_exp <- function(a, args, actlist) {
    list(adj = list(exp(args[[1]]) * a), exp(args[[1]]))
}
ret_log <- a_log <- function(a, args, actlist) {
    list(adj = list(a * dpartial_log(args[[1]])), log(args[[1]]))
}


a_t <- function(adj, x) {
    adr.reshape(t(adj), safedim(x))
}

rec_range <- range
a_range <- ret_range <- function(a, args, actlist) {
    x <- args[[1]]
    imin <- which.min(x)
    imax <- which.max(x)
    ar <- a_zeros(x)
    ar[[imin]] <- a[[1]]
    ar[[imax]] <- a[[2]]
    list(adj = list(ar))
}

rec_d <- function(f, ...) {
    d(f, ..., fname = getSource(f))
}
a_d <- ret_d <- function(...) {
    list(adj = list(0))
}

## expDefaultArgs <- function(f, args) {
##     fa <- args
##     fms <- formals(f)
##     if (!is.null(fms)) {
##         mc <- match.call(f, as.call(append(list('f'), args)))
##         namedArgs <- as.list(mc)[-1]
##         fa[names(namedArgs)] <- namedArgs[names(namedArgs)]
##         argNames = names(fms)
##         argNames['...'] <- NULL
##     }
##     fa
## }

a_do.call <- function(a, f, args, actlist = 1:length(args), fname = substitute(f)) {
                                        #    fa <- expDefaultArgs(f, args)
    afun <- agetfun(f, args, actlist, fname, adjmode = 'adj')
    fa <- fullargs(args, f)
                                        #    show(list(a_do.call.a=a,args=args,fa=fa))
    afun(a, fa, 1:length(args))$adj
}

a_append <- function(a, args, pos) {
    if (pos == 1) {
        asel <- a[1:length(args[[1]])]
        if (is.list(args[[1]]) || is.list(args[[2]])) {
            if (is.list(args[[1]])) {
                asel
            } else {
                do.call(c, asel)
            }
        } else {
            asel
        }
    } else {
        bsel <- a[-(1:length(args[[1]]))]
        if (is.list(args[[1]]) || is.list(args[[2]])) {
            if (is.list(args[[2]])) {
                bsel
            } else {
                do.call(c, bsel)
            }
        } else {
            bsel
        }
    }
}

rec_dcall <- function(f, dargs, args, actlist = 1:length(args), fname = substitute(f)) {
    if (is.expression(fname) || is.function(fname)) {
        fname <- getSource(fname)
    }


    dactlist <- actlist
    df <- dgetfun(f, args, dactlist, fname)

#    show(df)

    adf <- adj.rec(df, 1:2, fname = fname, envir = environment(df))

#    show(adf)

    aargs <- list(dargs, args)
    
#    show(aargs)
    if ('actlist' %in% names(formals(df))) {
        aargs <- append(aargs, list(actlist=dactlist))
    }
#    show('adj args')
                                        #    show(aargs)
    
    res <- do.call(adf, aargs)

    adr_push(df)
    adr_push(fname)

    res
}

ret_dcall <- a_dcall <- function(a, args, actlist) {
#    show('ret_dcall args')
#    show(args)
#    show('ret_dcall arg1,f')
                                        #    show(args[[1]])

#    show('ret_dcall env')
#    printEnvNames(parent.frame(2))
                                        #    cenv = parent.frame(2)
    dactlist <- 1:length(args[[2]])
    if (length(args) > 3) {
        dactlist <- args[[4]]
    }

    fname <- adr_pop()
    df <- adr_pop()

#    show(df)

    adf <- adj.ret(df, 1:2, fname = fname, envir = environment(df))

#    show(adf)

    aargs <- args[2:3]
#    show(aargs)
    if ('actlist' %in% names(formals(df))) {
        aargs <- append(aargs, list(actlist=dactlist))
    }
#    show('adj args')
#    show(aargs)
    ares <- adf(a, aargs, actlist[actlist>1] - 1)
                                        #    ares$adj <- list(ares$adj[[1]], ares$adj[[2]])
    if (1 %in% actlist) {
        ares$adj <- append(list(0), ares$adj)
    }
    ares
}

rec_d_zeros <- function(...) {
    d_zeros(...)
}
ret_d_zeros <- a_d_zeros <- function(adj, args, actlist) {
    list(adj=list(a_zeros(args[[1]])))
}

rec_lapply <- lapply

ret_lapply <- a_lapply <- function(a, args, actlist) {
    l <- args[[1]]
    f <- args[[2]]
    adjf <- adj(f, 1)
    lv <- lapply(rev(1:length(l)), function(i) {
        adjf(a[[i]], list(l[[i]]))
    })
    al <- lapply(rev(1:length(l)), function(i) {
        lv[[i]]$adj[[1]]
    })
    fl <- lapply(rev(1:length(l)), function(i) {
        lv[[i]]$f
    })
#    show(list(lapply.adj = list(al), f = fl))
    list(adj = list(al), f = fl)
}

rec_sapply <- sapply

ret_sapply <- a_sapply <- function(a, args, actlist) {
    l <- args[[1]]
    f <- args[[2]]
    adjf <- adj(f, 1)
    lv <- lapply(rev(1:length(l)), function(i) {
        adjf(a[[i]], list(l[[i]]))
    })
    al <- sapply(rev(1:length(l)), function(i) {
        lv[[i]]$adj[[1]]
    })
    fl <- sapply(rev(1:length(l)), function(i) {
        lv[[i]]$f
    })
#    show(list(sapply.adj = list(al), f = fl))
    list(adj = list(al), f = fl)
}

rec_array <- function(...)
    array(...)

dpartial_array <- function(a, dim) {
    sel <- array(1:length(a), dim)

    nin = length(a)
    nout = length(sel)
    
    J = matrix(0, nout, nin)
    J[cbind(1:nout, c(sel))] = 1

    J
}

ret_array <- a_array <- function(a, lx, actlist) {
    if (1 %in% actlist) {

        J <- dpartial_array(lx[[1]], lx[[2]])

        dim(a) <- c(1, length(a))
        adj1 <- a %*% J
        dim(adj1) <- dim(lx[[1]])

        adj1
    } else {
        adj1 <- a_zeros(a[[1]])
    }
    list(adj = list(data = adj1, dim = a_zeros(lx[[2]])))
}

rec_c <- function(...) c(...)

ret_c <- a_c <- function(a, lx, actlist) {
    adjl <- lapply(actlist, function(argi) {
        bx <- do.call(c,
                      lapply(1:length(lx), function(k) rep(if (k == argi) TRUE else FALSE, length(lx[[k]])))
                      )
        adjs <- a[bx]
        dim(adjs) <- dim(lx[[argi]])
        adjs
    })
    list(adj = adjl)
}

rec_pnorm <- function(...) pnorm(...)

ret_pnorm <- a_pnorm <- function(a, lx, actlist) {
    dp <- dpartial_pnorm(lx)
    list(adj = list(q = dp * a))
}

rec_dnorm <- function(...) dnorm(...)

ret_dnorm <- a_dnorm <- function(a, lx, actlist) {
    dp <- dpartial_dnorm(lx)
    list(adj = list(q = dp * a))
}

rec_adr_reshape <- rec_adr.reshape <- function(...)
    adr.reshape(...)

ret_adr_reshape <- a_adr_reshape <- ret_adr.reshape <- a_adr.reshape <- function(a, args, actlist) {
    dim(a) <- dim(args[[1]])
    list(adj = list(a, a_zeros(args[[2]])))
}

rec_print <- function(...) {
    args <- list(...)
    cat('rec_print: ')
    do.call(print, args)
}

ret_print <- function(a, args, actlist=c()) {
    cat('ret_print: ')
    do.call(print, args)
}

a_print <- function(a, args, actlist=c()) {
    cat('a_print: ')
    do.call(print, args)
}


rec_cat <- function(...) {
    args <- list(...)
    cat('rec_cat: ')
    do.call(cat, args)
}

ret_cat <- function(a, args, actlist=c()) {
    cat('ret_cat: ')
    do.call(cat, args)
}

a_cat <- function(a, args, actlist=c()) {
    cat('a_cat: ')
    do.call(cat, args)
}


rec_show <- function(...) {
    args <- list(...)
    cat('rec_show: ')
    do.call(show, args)
}

ret_show <- function(a, args, actlist=c()) {
    cat('ret_show: ')
    do.call(show, args)
}

a_show <- function(a, args, actlist=c()) {
    cat('a_show: ')
    do.call(show, args)
}


ret_is.null <- a_is.null <-
ret_is.complex <- a_is.complex <-
ret_is.double <- a_is.double <-
ret_is.numeric <- a_is.numeric <-
ret_is.array <- a_is.array <-
ret_is.matrix <- a_is.matrix <-
ret_is.function <- a_is.function <-
ret_is.list <- a_is.list <- function(a, x) {
    list(adj=list(0))
}

rec_rep <- rep
ret_rep <- a_rep <- function(a, lx, actlist) {
    x <- lx[[1]]
    each <- if ('each' %in% names(lx)) lx$each else if (length(lx) > 3) lx[[4]] else 1
    length.out <- if ('length.out' %in% names(lx)) lx$length.out else if (length(lx) > 2) lx[[3]] else NA
    times <- if ('times' %in% names(lx)) lx$times else if (length(lx) > 1) lx[[2]] else 1
    ax <- rep(a_zeros(x), each=each)
    if (is.na(length.out)) {
        for (k in 1:times) {
            ax <- ax + a[(k-1)*length(ax) + (1:length(ax))]
        }
    } else {
        times <- ceiling(length.out/length(ax))
        if (times>0) {
            for (k in seq_len(times-1)) {
                inds <- (k-1)*length(ax) + (1:length(ax))
                ax <- ax + a[inds]
            }
            loffs <- (times-1)*length(ax)+1
            if (loffs <= length(a)) {
                inds <- loffs:length(a)
                indsax <- 1:(length(a)-loffs+1)
                ax[indsax] <- ax[indsax] + a[inds]
            }
        }
    }
    dim(ax) <- c(each, length(x))
    ax2 <- colSums(ax)
    dim(ax2) <- safedim(x)
    list(adj = list(ax2))
}

rec_rep.int <- rep.int
ret_rep.int <- a_rep.int <- ret_rep
