setClass("adtay",
         representation("order" = "numeric", "val" = "ANY", "der" = "list"))

new.adtay <- function(x, ndd = adrGetOption('ndd'), order = adrGetOption('taylor-order')) {
#    if (is.null(x)) x <- 0
#    if (is.null(ndd)) ndd <- 1
#    if (is.null(order)) order <- 1
                                        #    show('new.adtay')
    if (is(x, "adtay")) {
        stop('Creating recursive adtay')
    }
    der <- rep(list(advec(x, ndd)), order)
    new("adtay", order = order, val = x, der = der)
}

adtay <- function(x, ndd = adrGetOption('ndd'), order = adrGetOption('taylor-order')) {
    new.adtay(x, ndd, order)
}

rand.adtay <- function(x, ndd = adrGetOption('ndd'), order = adrGetOption('taylor-order')) {
    r <- adtay(x, ndd, order)
    r@der <- lapply(r@der, function(x) {
        rand_advec(x, ndd)
    })
    r
}

is.adtay <- function(x) {
    is(x, "adtay")
}

reprl.adtay <- function(x) {
    list(class(x), x@order, x@val, x@der)
}


compare.adtay <- function(e1, e2) {
    callGeneric(e1@val, e2@val)
}
compare.sadtay <- function(e1, e2) {
    callGeneric(e1, e2@val)
}
compare.adtays <- function(e1, e2) {
    callGeneric(e1@val, e2)
}
setMethod(Compare, signature(e1="adtay", e2="adtay"),   compare.adtay)
setMethod(Compare, signature(e1="adtay"), compare.adtays)
setMethod(Compare, signature(e2="adtay"), compare.sadtay)

setMethod('is.numeric',  signature(x="adtay"),  function(x) { is.numeric(x@val)  })
#setMethod('is.complex',  signature(x="adtay"),  function(x) { is.complex(x@val)  })
setMethod('is.finite',   signature(x="adtay"),  function(x) { is.finite(x@val)   })
setMethod('is.infinite', signature(x="adtay"),  function(x) { is.infinite(x@val) })
setMethod('is.nan',      signature(x="adtay"),  function(x) { is.nan(x@val)      })
setMethod('is.na',       signature(x="adtay"),  function(x) { c(is.na(x@val), do.call(cbind, lapply(x@der, is.na)))  })

plustt.adtay <- function(e1, e2) {
    r <- e1
    r@val <- e1@val + e2@val
    r@der <- lapply(1:e1@order, function(i) {
        e1@der[[i]] + e2@der[[i]]
    })
    r
}
plustn.adtay <- function(e1, e2) {
    r <- e1
    r@val <- e1@val + e2
    dz <- advec(e2, e1@der[[1]]@ndd)
    r@der <- lapply(1:e1@order, function(i) {
        e1@der[[i]] + dz
    })
    r
}
plusnt.adtay <- function(e1, e2) {
    r <- e2
    r@val <- e1 + e2@val
    dz <- advec(e1, e2@der[[1]]@ndd)
    r@der <- lapply(1:e2@order, function(i) {
        dz + e2@der[[i]]
    })
    r
}
plusu.adtay <- function(e1) {
    r <- e1
    r@val <- +e1@val
    r@der <- lapply(1:e1@order, function(i) {
        +e1@der[[i]]
    })
    r
}
setMethod('+', signature(e1="adtay", e2="adtay"),   plustt.adtay)
setMethod('+', signature(e1="adtay"), plustn.adtay)
setMethod('+', signature(e2="adtay"), plusnt.adtay)
setMethod('+', signature(e1="adtay", e2="missing"), plusu.adtay)


minustt.adtay <- function(e1, e2) {
    r <- e1
    r@val <- e1@val - e2@val
    r@der <- lapply(1:e1@order, function(i) {
        e1@der[[i]] - e2@der[[i]]
    })
    r
}
minustn.adtay <- function(e1, e2) {
    r <- e1
    r@val <- e1@val - e2
    dz <- advec(e2, e1@der[[1]]@ndd)
    r@der <- lapply(1:e1@order, function(i) {
        e1@der[[i]] - dz
    })
    r
}
minusnt.adtay <- function(e1, e2) {
    r <- e2
    r@val <- e1 - e2@val
    dz <- advec(e2, e2@der[[1]]@ndd)
    r@der <- lapply(1:e2@order, function(i) {
        dz - e2@der[[i]]
    })
    r
}
minusu.adtay <- function(e1) {
    r <- e1
    r@val <- -e1@val
    r@der <- lapply(1:e1@order, function(i) {
        -e1@der[[i]]
    })
    r
}
setMethod('-', signature(e1="adtay", e2="adtay"),   minustt.adtay)
setMethod('-', signature(e1="adtay"), minustn.adtay)
setMethod('-', signature(e2="adtay"), minusnt.adtay)
setMethod('-', signature(e1="adtay", e2="missing"), minusu.adtay)


timestt.adtay <- function(e1, e2) {
    r <- e1
    r@val <- e1@val * e2@val
    r@der <- lapply(1:e1@order, function(i) {
        e1@der[[i]]*e2@val + e1@val*e2@der[[i]]
    })
    r
}
timestn.adtay <- function(e1, e2) {
    r <- e1
    r@val <- e1@val * e2
    r@der <- lapply(1:e1@order, function(i) {
        e1@der[[i]]*e2
    })
    r
}
timesnt.adtay <- function(e1, e2) {
    r <- e2
    r@val <- e1 * e2@val
    r@der <- lapply(1:e2@order, function(i) {
        e1*e2@der[[i]]
    })
    r
}
setMethod('*', signature(e1="adtay", e2="adtay"),   timestt.adtay)
setMethod('*', signature(e1="adtay"), timestn.adtay)
setMethod('*', signature(e2="adtay"), timesnt.adtay)


dividett.adtay <- function(e1, e2) {
    r <- e1
    r@val <- e1@val / e2@val
    r@der <- lapply(1:e1@order, function(i) {
        (e1@der[[i]]*e2@val - e1@val*e2@der[[i]]) / e2@val^2
    })
    r
}
dividetn.adtay <- function(e1, e2) {
    r <- e1
    r@val <- e1@val / e2
    r@der <- lapply(1:e1@order, function(i) {
        (1/e2)*e1@der[[i]]
    })
    r
}
divident.adtay <- function(e1, e2) {
    r <- e2
    r@val <- e1 / e2@val
    r@der <- lapply(1:e2@order, function(i) {
        (-e1 / e2@val^2) * e2@der[[i]]
    })
    r
}
setMethod('/', signature(e1="adtay", e2="adtay"),   dividett.adtay)
setMethod('/', signature(e1="adtay"), dividetn.adtay)
setMethod('/', signature(e2="adtay"), divident.adtay)


idividett.adtay <- function(e1, e2) {
    r <- e1
    r@val <- e1@val %/% e2@val
    r@der <- lapply(1:e1@order, function(i) {
        e1@der[[i]]*0 + e2@der[[i]]*0
    })
    r
}
idividetn.adtay <- function(e1, e2) {
    r <- e1
    r@val <- e1@val %/% e2
    r@der <- lapply(1:e1@order, function(i) {
        e1@der[[i]]*0
    })
    r
}
idivident.adtay <- function(e1, e2) {
    r <- e2
    r@val <- e1 %/% e2@val
    r@der <- lapply(1:e2@order, function(i) {
        e2@der[[i]]*0
    })
    r
}
setMethod('%/%', signature(e1="adtay", e2="adtay"),   idividett.adtay)
setMethod('%/%', signature(e1="adtay"), idividetn.adtay)
setMethod('%/%', signature(e2="adtay"), idivident.adtay)


modtt.adtay <- function(e1, e2) {
    r <- e1
    r@val <- e1@val %% e2@val
    r@der <- lapply(1:e1@order, function(i) {
        e1@der[[i]] - e2@der[[i]] * (e1@val %/% e2@val)
    })
    r
}
modtn.adtay <- function(e1, e2) {
    r <- e1
    r@val <- e1@val %% e2
    r
}
modnt.adtay <- function(e1, e2) {
    r <- e2
    r@val <- e1 %% e2@val
    r@der <- lapply(1:e2@order, function(i) {
        e2@der[[i]] * -(e1 %/% e2@val)
    })
    r
}
setMethod('%%', signature(e1="adtay", e2="adtay"),   modtt.adtay)
setMethod('%%', signature(e1="adtay"), modtn.adtay)
setMethod('%%', signature(e2="adtay"), modnt.adtay)


powertt.adtay <- function(e1, e2) {
    r <- e1
    r@val <- e1@val ^ e2@val
    r@der <- lapply(1:e1@order, function(i) {
        (e1@val^(e2@val - 1)*e2@val)*e1@der[[i]] + (log(e1@val)*(e1@val^e2@val))*e2@der[[i]]
    })
    r
}
powertn.adtay <- function(e1, e2) {
    r <- e1
    r@val <- e1@val ^ e2
    r@der <- lapply(1:e1@order, function(i) {
        (e1@val^(e2 - 1)*e2)*e1@der[[i]]
    })
    r
}
powernt.adtay <- function(e1, e2) {
    r <- e2
    r@val <- e1 ^ e2@val
    r@der <- lapply(1:e2@order, function(i) {
        (log(e1)*(e1^e2@val))*e2@der[[i]]
    })
    r
}
setMethod('^', signature(e1="adtay", e2="adtay"),   powertt.adtay)
setMethod('^', signature(e1="adtay"), powertn.adtay)
setMethod('^', signature(e2="adtay"), powernt.adtay)


sin.adtay <- function(x) {
    r <- x
    r@val <- sin(x@val)
    r@der <- lapply(1:x@order, function(i) {
        cos(x@val)*x@der[[i]]
    })
#    show(list(sin.adtay.r=r))
    r
}
setMethod('sin', signature(x="adtay"), sin.adtay)

cos.adtay <- function(x) {
    r <- x
    r@val <- cos(x@val)
    r@der <- lapply(1:x@order, function(i) {
        -sin(x@val)*x@der[[i]]
    })
#    show(list(cos.adtay.r=r))
    r
}
setMethod('cos', signature(x="adtay"), cos.adtay)

tan.adtay <- function(x) {
    r <- x
    r@val <- tan(x@val)
    r@der <- lapply(1:x@order, function(i) {
        dpartial_tan(x@val)*x@der[[i]]
    })
    r
}
setMethod('tan', signature(x="adtay"), tan.adtay)

sinh.adtay <- function(x) {
    r <- x
    r@val <- sinh(x@val)
    r@der <- lapply(1:x@order, function(i) {
        cosh(x@val)*x@der[[i]]
    })
#    show(list(sinh.adtay.r=r))
    r
}
setMethod('sinh', signature(x="adtay"), sinh.adtay)

cosh.adtay <- function(x) {
    r <- x
    r@val <- cosh(x@val)
    r@der <- lapply(1:x@order, function(i) {
        sinh(x@val)*x@der[[i]]
    })
#    show(list(cosh.adtay.r=r))
    r
}
setMethod('cosh', signature(x="adtay"), cosh.adtay)

tanh.adtay <- function(x) {
    r <- x
    r@val <- tanh(x@val)
    r@der <- lapply(1:x@order, function(i) {
        dpartial_tanh(x@val)*x@der[[i]]
    })
    r
}
setMethod('tanh', signature(x="adtay"), tanh.adtay)

asin.adtay <- function(x) {
    r <- x
    r@val <- asin(x@val)
    r@der <- lapply(1:x@order, function(i) {
        dpartial_asin(x@val)*x@der[[i]]
    })
    r
}
setMethod('asin', signature(x="adtay"), asin.adtay)
acos.adtay <- function(x) {
    r <- x
    r@val <- acos(x@val)
    r@der <- lapply(1:x@order, function(i) {
        dpartial_acos(x@val)*x@der[[i]]
    })
    r
}
setMethod('acos', signature(x="adtay"), acos.adtay)
atan.adtay <- function(x) {
    r <- x
    r@val <- atan(x@val)
    r@der <- lapply(1:x@order, function(i) {
        dpartial_atan(x@val)*x@der[[i]]
    })
    r
}
setMethod('atan', signature(x="adtay"), atan.adtay)

asinh.adtay <- function(x) {
    r <- x
    r@val <- asinh(x@val)
    r@der <- lapply(1:x@order, function(i) {
        dpartial_asinh(x@val)*x@der[[i]]
    })
    r
}
setMethod('asinh', signature(x="adtay"), asinh.adtay)
acosh.adtay <- function(x) {
    r <- x
    r@val <- acosh(x@val)
    r@der <- lapply(1:x@order, function(i) {
        dpartial_acosh(x@val)*x@der[[i]]
    })
    r
}
setMethod('acosh', signature(x="adtay"), acosh.adtay)
atanh.adtay <- function(x) {
    r <- x
    r@val <- atanh(x@val)
    r@der <- lapply(1:x@order, function(i) {
        dpartial_atanh(x@val)*x@der[[i]]
    })
    r
}
setMethod('atanh', signature(x="adtay"), atanh.adtay)


mtimestt.adtay <- function(x, y) {
    r <- x
#    show(list(mtimestt.adtay.x=x,y=y))
    r@val <- x@val %*% y@val
    r@der <- lapply(1:x@order, function(i) {
        x@der[[i]]%*%y@val + x@val%*%y@der[[i]]
    })
    r
}
mtimestn.adtay <- function(x, y) {
    r <- x
#    show(list(mtimestn.adtay.x=x,y=y))
    r@val <- x@val %*% y
    r@der <- lapply(1:x@order, function(i) {
        x@der[[i]]%*%y
    })
    r
}
mtimesnt.adtay <- function(x, y) {
    r <- y
    r@val <- x %*% y@val
    r@der <- lapply(1:y@order, function(i) {
        x%*%y@der[[i]]
    })
    r
}
setMethod('%*%', signature(x="adtay", y="adtay"),   mtimestt.adtay)
setMethod('%*%', signature(x="adtay"), mtimestn.adtay)
setMethod('%*%', signature(y="adtay"), mtimesnt.adtay)


## seq.adtay <- function(from = 1, to = 1, by = ((to - from)/(length.out - 1)),
##                       length.out = NULL, along.with = NULL, ...) {
##     show(list('adtay.seq'))
##     r <- x
## #    r@val <- x@val : y@val
##     r
## }
## setMethod('seq', 'adtay', seq.adtay)

## colontt.adtay <- function(x, y) {
##     r <- x
##     r@val <- x@val : y@val
##     r
## }
## colontn.adtay <- function(x, y) {
##     r <- x
##     r@val <- x@val : y
##     r
## }
## colonnt.adtay <- function(x, y) {
##     r <- y
##     r@val <- x : y@val
##     r@der <- lapply(1:y@order, function(i) {
##         y@der[[i]]*0
##     })
##     r
## }
#setGeneric(':', def=function(from, to) {})
#setMethod(':', 'adtay', colontt.adtay)
#setMethod(':', signature(x="adtay"), colontn.adtay)
#setMethod(':', signature(y="adtay"), colonnt.adtay)


exp.adtay <- function(x) {
    r <- x
    r@val <- exp(x@val)
    r@der <- lapply(1:x@order, function(i) {
        exp(x@val)*x@der[[i]]
    })
    r
}
setMethod('exp', signature(x="adtay"), exp.adtay)


log.adtay <- function(x) {
    r <- x
    r@val <- log(x@val)
    r@der <- lapply(1:x@order, function(i) {
        (1/x@val)*x@der[[i]]
    })
    r
}
setMethod('log', signature(x="adtay"), log.adtay)


abs.adtay <- function(x) {
    r <- x
    r@val <- abs(x@val)
    r@der <- lapply(1:x@order, function(i) {
        (Re(x@val) * Re(x@der[[i]]) + Im(x@val) * Im(x@der[[i]])) / r@val
    })
    r
}
setMethod('abs', signature(x="adtay"), abs.adtay)


sqrt.adtay <- function(x) {
    r <- x
    r@val <- sqrt(x@val)
    r@der <- lapply(1:x@order, function(i) {
        x@der[[i]]*dpartial_sqrt(x@val)
    })
    r
}
setMethod('sqrt', signature(x="adtay"), sqrt.adtay)


pnorm.adtay <- function(q, mean = 0, sd = 1, lower.tail = TRUE, log.p = FALSE) {
    r <- q
    r@val <- pnorm(q@val, mean, sd, lower.tail, log.p)
    r@der <- lapply(1:q@order, function(i) {
        q@der[[i]]*dpartial_pnorm(list(q = q@val, mean = mean, sd = sd, lower.tail = lower.tail, log.p = log.p))
    })
    r
}
setMethod('pnorm', signature(q="adtay"), pnorm.adtay)

dnorm.adtay <- function(x, mean = 0, sd = 1, log = FALSE) {
    r <- x
    r@val <- dnorm(x@val, mean, sd, log)
    r@der <- lapply(1:x@order, function(i) {
        x@der[[i]]*dpartial_dnorm(list(x = x@val, mean = mean, sd = sd, log = log))
    })
    r
}
setMethod('dnorm', signature(x="adtay"), dnorm.adtay)


sum.adtay <- function(x, ..., na.rm = FALSE) {
    r <- x
    args <- list(x, ...)
#    show(list(sum.adtay.x=x))
    r@val <- sum(x@val)
    r@val <- do.call(sum, append(lapply(args, function(t) sum(t@val, na.rm=na.rm)), list(na.rm=na.rm)))
    r@der <- lapply(1:x@order, function(i) {
        do.call(sum, lapply(args, function(t) {
            nal <- if (na.rm) !is.na(t@val) else if (length(t)>0) TRUE else c()
            sum(t@der[[i]][nal])
        }))
    })
    r
}
setMethod('sum', signature(x="adtay"), sum.adtay)

norm.adtay <- function(x, type) {
    r <- x
    if (missing(type)) {
        type <- '2'
    }
    r@val <- norm(x@val, type)
    df_norm.norm_p_repl <- adr.repl.norm_p(type)
    df_normfun <- d(df_norm.norm_p_repl)
    r@der <- lapply(1:x@order, function(i) {
        df_normfun(list(x@der[[i]]), list(x@val, type))$df
    })
    r
}
setMethod('norm', signature(x="adtay"), norm.adtay)

c.adtay <- function(x, ...) {
    r <- x
#    show(list(c.adtay.x=x))
    args <- list(x, ...)
    r@val <- do.call(c, lapply(args, function(t) if (is(t, 'adtay')) t@val else t))
    r@der <- lapply(1:x@order, function(i) {
        do.call(c, lapply(args, function(t) if (is(t, 'adtay')) t@der[[i]] else d_zeros(t)))
    })
    r
}
setMethod("c", signature(x = "adtay"), c.adtay)

adr_c <- function(...) {
    ##    show('adr_c')
    isadtay <- sapply(list(...), is.adtay)
    if (any(isadtay)) {
        ##        show('mydispatch')
        adr_c_adtay(...)
    } else {
        c(...)
    }
}
adr_c_adtay <- function(...) {
    isadtay <- sapply(list(...), is.adtay)
    n <- which(isadtay)[[1]]
    x <- list(...)[[ n ]]
    r <- x
    ##    show(list(adr_c_adtay.x=x,n=n))
    args <- list(...)
    r@val <- do.call(c, lapply(args, function(t) if (is(t, 'adtay')) t@val else t))
    r@der <- lapply(1:x@order, function(i) {
        do.call(c, lapply(args, function(t) if (is(t, 'adtay')) t@der[[i]] else d_zeros(t)))
    })
    r
}
setGeneric("adr_c")
setMethod("adr_c", "adtay", adr_c_adtay)

rbind2.adtay <- function(x, y, ...) {
#    show('rbind2.adtay')
    r <- x
    r@val <- rbind2(x@val, y@val, ...)
    r@der <- lapply(1:x@order, function(i) {
        rbind2(x@der[[i]], y@der[[i]], ...)
    })
    r
}
rbind2.adtays <- function(x, y, ...) {
#    show('rbind2.adtays')
#    show(class(x))
#    show(class(y))
    r <- x
    r@val <- rbind2(x@val, y, ...)
    ndd <- x@der[[1]]@ndd
    r@der <- lapply(1:x@order, function(i) {
        rbind2(x@der[[i]], advec(y, ndd), ...)
    })
#    show(r)
    r
}
rbind2.sadtay <- function(x, y, ...) {
#    show('rbind2.sadtay')
    r <- y
    r@val <- rbind2(x, y@val, ...)
    ndd <- y@der[[1]]@ndd
    r@der <- lapply(1:y@order, function(i) {
        rbind2(advec(x, ndd), y@der[[i]], ...)
    })
    r
}
setMethod("rbind2", signature(x = "adtay", y = "adtay"), rbind2.adtay)
setMethod("rbind2", signature(x = "adtay"), rbind2.adtays)
setMethod("rbind2", signature(y = "adtay"), rbind2.sadtay)

cbind2.adtay <- function(x, y, ...) {
#    show('cbind2.adtay')
#    show(list(x=x,y=y,args=list(...)))
    r <- x
    r@val <- cbind2(x@val, y@val, ...)
    r@der <- lapply(1:x@order, function(i) {
        cbind2(x@der[[i]], y@der[[i]], ...)
    })
#    show(list(res.cbind2.adtay=r))
    r
}
cbind2.adtays <- function(x, y, ...) {
#    show('cbind2.adtays')
#    show(list(x=x,y=y,args=list(...)))
#    show(class(x))
#    show(class(y))
    r <- x
    r@val <- cbind2(x@val, y, ...)
    ndd <- x@der[[1]]@ndd
    r@der <- lapply(1:x@order, function(i) {
        cbind2(x@der[[i]], advec(y, ndd), ...)
    })
#    show(list(res=r))
    r
}
cbind2.sadtay <- function(x, y, ...) {
#    show('cbind2.sadtay')
#    show(list(x=x,y=y,args=list(...)))
    r <- y
    r@val <- cbind2(x, y@val, ...)
    ndd <- y@der[[1]]@ndd
    r@der <- lapply(1:y@order, function(i) {
        cbind2(advec(x, ndd), y@der[[i]], ...)
    })
#    show(list(res=r))
    r
}
setMethod("cbind2", signature(x = "adtay", y = "adtay"), cbind2.adtay)
setMethod("cbind2", signature(x = "adtay"), cbind2.adtays)
setMethod("cbind2", signature(y = "adtay"), cbind2.sadtay)


kronecker.adtay <- function(X, Y, ...) {
#    show('kronecker.adtay')
#    show(list(X=X,Y=Y,args=list(...)))
    r <- X
    r@val <- kronecker(X@val, Y@val, ...)
    r@der <- lapply(1:X@order, function(i) {
        kronecker(X@der[[i]], Y@val, ...) + kronecker(X@val, Y@der[[i]], ...)
    })
#    show(list(res.kronecker.adtay=r))
    r
}
kronecker.adtays <- function(X, Y, ...) {
#    show('kronecker.adtays')
#    show(list(X=X,Y=Y,args=list(...)))
#    show(class(X))
#    show(class(Y))
    r <- X
    r@val <- kronecker(X@val, Y, ...)
    r@der <- lapply(1:X@order, function(i) {
        kronecker(X@der[[i]], Y, ...)
    })
#    show(list(res=r))
    r
}
kronecker.sadtay <- function(X, Y, ...) {
#    show('kronecker.sadtay')
#    show(list(X=X,Y=Y,args=list(...)))
    r <- Y
    r@val <- kronecker(X, Y@val, ...)
    r@der <- lapply(1:Y@order, function(i) {
#        showMethods(kronecker, signature(Y=class(Y@der[[i]])))
#        showMethods(outer, signature(Y=class(Y@der[[i]])))
        kronecker(X, Y@der[[i]], ...)
    })
#    show(list(res=r))
    r
}
setMethod("kronecker", signature(X = "adtay", Y = "adtay"), kronecker.adtay)
setMethod("kronecker", signature(X = "adtay"), kronecker.adtays)
setMethod("kronecker", signature(Y = "adtay"), kronecker.sadtay)

## second version using partials
## kronecker_adtay_ay <- function(X, Y, ...) {
##     r <- X
##     P <- partial_kronecker_l(X@val, Y)
##     r@val <- kronecker(r@val, Y)
##     r@der <- lapply(1:r@order, function(i) {
##         dp <- r@der[[i]]
##         dim(dp) <- c(length(dp), 1)
##         dz <- P %*% dp
##         dim(dz) <- dim(r@val)
##         dz
##     })
##     r
## }
## kronecker_adtay_xa <- function(X, Y, ...) {
##     r <- Y
##     P <- partial_kronecker_r(X, Y@val)
##     r@val <- kronecker(r, Y@val)
##     r@der <- lapply(1:r@order, function(i) {
##         dp <- r@der[[i]]
##         dim(dp) <- c(length(dp), 1)
##         dz <- P %*% dp
##         dim(dz) <- dim(r@val)
##         dz
##     })
##     r
## }
## kronecker_adtay_aa <- function(X, Y, ...) {
##     r <- X
##     Pl <- partial_kronecker_l(X@val, Y@val)
##     Pr <- partial_kronecker_r(X@val, Y@val)
##     r@val <- kronecker(r@val, Y@val)
##     r@der <- lapply(1:r@order, function(i) {
##         dp <- X@der[[i]]
##         dq <- Y@der[[i]]
##         dim(dp) <- c(length(dp), 1)
##         dim(dq) <- c(length(dq), 1)
##         dz <- Pl %*% dp + Pr %*% dq
##         dim(dz) <- dim(r@val)
##         dz
##     })
##     r
## }
## setMethod("kronecker", signature(X = "adtay"), kronecker_adtay_ay)
## setMethod("kronecker", signature(Y = "adtay"), kronecker_adtay_xa)
## setMethod("kronecker", signature(X = "adtay", Y = "adtay"), kronecker_adtay_aa)

colSums_adtay <- function(x, na.rm = FALSE, dims = 1) {
    r <- x
    r@val <- colSums(x@val, na.rm=na.rm, dims=dims)
    r@der <- lapply(1:x@order, function(i) {
        colSums(x@der[[i]], na.rm=na.rm, dims=dims)
    })
    r
}
setMethod("colSums", signature(x = "adtay"), colSums_adtay)

colMeans_adtay <- function(x, na.rm = FALSE, dims = 1) {
    r <- x
    r@val <- colMeans(x@val, na.rm=na.rm, dims=dims)
    r@der <- lapply(1:x@order, function(i) {
        colMeans(x@der[[i]], na.rm=na.rm, dims=dims)
    })
    r
}
setMethod("colMeans", signature(x = "adtay"), colMeans_adtay)

outer.adtay <- function(X, Y, ...) {
#    show('outer.adtay')
#    show(list(X=X,Y=Y,args=list(...)))
    r <- X
    r@val <- outer(X@val, Y@val, ...)
    r@der <- lapply(1:X@order, function(i) {
        outer(X@der[[i]], Y@val, ...) + outer(X@val, Y@der[[i]], ...)
    })
#    show(list(res.outer.adtay=r))
    r
}
outer.adtays <- function(X, Y, ...) {
#    show('outer.adtays')
#    show(list(X=X,Y=Y,args=list(...)))
#    show(class(X))
#    show(class(Y))
    r <- X
    r@val <- outer(X@val, Y, ...)
    r@der <- lapply(1:X@order, function(i) {
        outer(X@der[[i]], Y, ...)
    })
#    show(list(res=r))
    r
}
outer.sadtay <- function(X, Y, ...) {
#    show('outer.sadtay')
#    show(list(X=X,Y=Y,args=list(...)))
    r <- Y
    r@val <- outer(X, Y@val, ...)
    r@der <- lapply(1:Y@order, function(i) {
        outer(X, Y@der[[i]], ...)
    })
#    show(list(res=r))
    r
}
setMethod("outer", signature(X = "adtay", Y = "adtay"), outer.adtay)
setMethod("outer", signature(X = "adtay"), outer.adtays)
setMethod("outer", signature(Y = "adtay"), outer.sadtay)


rep.adtay <- function(x, ...) {
#    show('rep.adtay')
    r <- x
    r@val <- rep(x@val, ...)
    r@der <- lapply(1:x@order, function(i) {
        rep(x@der[[i]], ...)
    })
    r
}
setMethod("rep", signature(x = "adtay"), rep.adtay)


Re_adtay <- function(z) {
    r <- z
    r@val <- Re(z@val)
    r@der <- lapply(1:z@order, function(i) {
        Re(z@der[[i]])
    })
    r
}
setMethod('Re', signature(z = "adtay"), Re_adtay)
Im_adtay <- function(z) {
    r <- z
    r@val <- Im(z@val)
    r@der <- lapply(1:z@order, function(i) {
        Im(z@der[[i]])
    })
    r
}
setMethod('Im', signature(z = "adtay"), Im_adtay)
Mod_adtay <- function(z) {
    r <- z
    r@val <- Mod(z@val)
    r@der <- lapply(1:z@order, function(i) {
        z@der[[i]] # TODO
    })
    r
}
setMethod('Mod', signature(z = "adtay"), Mod_adtay)
Arg_adtay <- function(z) {
    r <- z
    r@val <- Arg(z@val)
    r@der <- lapply(1:z@order, function(i) {
        z@der[[i]] # TODO
    })
    r
}
setMethod('Arg', signature(z = "adtay"), Arg_adtay)
Conj_adtay <- function(z) {
    r <- z
    r@val <- Conj(z@val)
    r@der <- lapply(1:z@order, function(i) {
        Conj(z@der[[i]])
    })
    r
}
setMethod('Conj', signature(z = "adtay"), Conj_adtay)

fft_adtay <- function(z, inverse = FALSE) {
    r <- z
    r@der <- lapply(1:z@order, function(i) {
        fft(z@der[[i]], inverse)
    })
    r@val <- fft(z@val, inverse)
    r
}
setMethod('fft', signature(z = "adtay"), fft_adtay)

mvfft_adtay <- function(z, inverse = FALSE) {
    r <- z
    r@der <- lapply(1:z@order, function(i) {
        mvfft(z@der[[i]], inverse)
    })
    r@val <- mvfft(z@val, inverse)
    r
}
setMethod('mvfft', signature(z = "adtay"), mvfft_adtay)

max_adtay <- function(x, ..., na.rm) {
    args <- list(x, ...)
    r <- x
    maxOfEach <- sapply(args, function(a) max(if (is(a, 'adtay')) a@val else a, na.rm=na.rm))
    if (na.rm == FALSE && any(is.na(maxOfEach))) {
        r <- adtay(NA)
    } else {
        maxi <- which.max(maxOfEach)
        marg <- args[[maxi]]
        maxj <- which.max(if (is(marg, 'adtay')) marg@val else marg)
        r <- if (is(marg, 'adtay')) marg[[maxj]] else adtay(marg[[maxj]])
    }
    r
}
setMethod("max", signature(x = "adtay"), max_adtay)

min_adtay <- function(x, ..., na.rm) {
    args <- list(x, ...)
    r <- x
    minOfEach <- sapply(args, function(a) min(if (is(a, 'adtay')) a@val else a, na.rm=na.rm))
    if (na.rm == FALSE && any(is.na(minOfEach))) {
        r <- adtay(NA)
    } else {
        mini <- which.min(minOfEach)
        marg <- args[[mini]]
        minj <- which.min(if (is(marg, 'adtay')) marg@val else marg)
        r <- if (is(marg, 'adtay')) marg[[minj]] else adtay(marg[[minj]])
    }
    r
}
setMethod("min", signature(x = "adtay"), min_adtay)

aperm_adtay <- function(a, perm) {
    r <- a
    r@der <- lapply(1:r@order, function(i) {
        aperm(r@der[[i]], perm)
    })
    r@val <- aperm(r@val, perm)
    r
}
setMethod("aperm", signature(a = "adtay"), aperm_adtay)

t.adtay <- function(x) {
#    show(list(t.adtay.x=x, dx=dim(x), dvx=dim(x@val), ddx=dim(x@der[[1]])))
    r <- x
    r@val <- t(x@val)
    r@der <- lapply(1:x@order, function(i) {
                                        #        t(x@der[[i]])
        x@der[[i]] <- t(x@der[[i]])
        dim(x@der[[i]]) <- dim(r@val)
        x@der[[i]]
    })
#    show(list(t.adtay.r=r))
    r
}
setMethod("t", signature(x = "adtay"), t.adtay)


rep.adtay <- function(x, times = 1, length.out = NA, each = 1) {
    r <- x
    r@val <- rep(x@val, times=times, length.out=length.out, each=each)
    r@der <- lapply(1:x@order, function(i) {
        rep(x@der[[i]], times=times, length.out=length.out, each=each)
    })
    r
}
setMethod("rep", signature(x = "adtay"), rep.adtay)


array.adtay <- function(data, dim = length(data), dimnames = NULL) {
#    show('array.adtay')
    r <- data
    r@val <- array(data@val, dim, dimnames)
    alen <- length(r@val)
    vlen <- length(data@val)
    nrep <- ceiling(alen/vlen)
    
    J <- dpartial_array(data, dim)
    
    r@der <- lapply(1:data@order, function(i) {
#        show(list(der.i=i, c=c(data@der[[i]])))
        adr_reshape(J %*% t(t(c(data@der[[i]]))), dim(r@val))
    })

    r
}
setMethod("array", signature(data = "adtay"), array.adtay)

as.array.adtay <- function(x, ...) {
#    show('as.array.adtay')
    r <- x
    r@val <- as.array(x@val, ...)
    r@der <- lapply(1:x@order, function(i) {
        as.array(x@der[[i]], ...)
    })
    r
}
setMethod("as.array", signature(x = "adtay"), as.array.adtay)


as.matrix.adtay <- function(x, ...) {
#    show('as.matrix.adtay')
    r <- x
    r@val <- as.matrix(x@val, ...)
    r@der <- lapply(1:x@order, function(i) {
        as.matrix(x@der[[i]], ...)
    })
    r
}
setMethod("as.matrix", signature(x = "adtay"), as.matrix.adtay)


as.vector.adtay <- function(x, mode) {
#    show('as.vector.adtay')
    r <- x
    r@val <- as.vector(x@val, mode)
    r@der <- lapply(1:x@order, function(i) {
        as.vector(x@der[[i]], mode)
    })
    r
}
setMethod("as.vector", signature(x = "adtay"), as.vector.adtay)


dimnames.adtay <- function(x) {
    r <- dimnames(x@val)
    r
}
setMethod("dimnames", signature(x = "adtay"), dimnames.adtay)

dimnames_lhs.adtay <- function(x, value) {
    dimnames(x@val) <- value
    x
}
setMethod("dimnames<-", signature(x = "adtay"), dimnames_lhs.adtay)


ncol.adtay <- function(x) {
    ncol(x@val)
}
setMethod("ncol", signature(x = "adtay"), ncol.adtay)

nrow.adtay <- function(x) {
    nrow(x@val)
}
setMethod("nrow", signature(x = "adtay"), nrow.adtay)

NCOL.adtay <- function(x) {
    NCOL(x@val)
}
setMethod("NCOL", signature(x = "adtay"), NCOL.adtay)

NROW.adtay <- function(x) {
    NROW(x@val)
}
setMethod("NROW", signature(x = "adtay"), NROW.adtay)

dim.adtay <- function(x) {
    dim(x@val)
}
setMethod("dim", signature(x = "adtay"), dim.adtay)

adr_reshape.adtay <- function(x, sz) {
    r <- x
#    show(list(adr_reshape.adtay.x=x,sz=sz))
    dim(r@val) <- sz
    if (is.null(sz)) {
        sz <- length(x)
    }
    r@der <- lapply(r@der, function(t) {
#        show(list(adr_reshape.adtay.t=t,sz=sz))
        dim(t) <- sz
        t
    })
    r
}
## setMethod("adr_reshape", signature(x = "adtay"), adr_reshape.adtay)

`dim<-.adtay` <- function(x, value) {
    adr_reshape.adtay(x, value)
}
setMethod("dim<-", signature(x = "adtay"), `dim<-.adtay`)

length.adtay <- function(x) {
    length(x@val)
}
setMethod("length", signature(x = "adtay"), length.adtay)


`[.adtay` <- function(x, i, j, ..., drop=TRUE) {
    r <- x
    iargs <- as.list(match.call(definition=function(...){}))[-c(1,2)]
    iargs <- lapply(iargs, evalind)
    iargs <- lapply(iargs, function(t) if (is.expression(t)) TRUE else t)
#    iargs <- list(i, j, ..., drop=drop)
#    show(list(sel.adtay.iargs=iargs))
    xargs <- append(list(x@val), iargs)
    r@val <- do.call('[', xargs)
    r@der <- lapply(r@der, function(t) {
        xargs <- append(list(t), iargs)
        do.call('[', xargs)
    })
    r
}
setMethod('[', signature(x='adtay'), `[.adtay`)


`[[.adtay` <- function(x, i, ...) {
    r <- x
    iargs <- as.list(match.call(definition=function(...){}))[-c(1,2)]
    iargs <- lapply(iargs, evalind)
#    iargs <- list(i, ...)
    xargs <- append(list(x@val), iargs)
    r@val <- do.call('[[', xargs)
    r@der <- lapply(r@der, function(t) {
        xargs <- append(list(t), iargs)
#        show(list(t=t,iargs=iargs,xargs=xargs))
        do.call('[[', xargs)
    })
    r
}
setMethod('[[', signature(x='adtay'), `[[.adtay`)


`[<-.adtay` <- function(x, i, j, ..., value) {
    r <- x
    iargs <- as.list(match.call(definition=function(...){}))
    iargs <- iargs[-c(1,2,length(iargs))]
    iargs <- lapply(iargs, evalind)
    iargs <- lapply(iargs, function(t) if (is.expression(t)) TRUE else t)
#    iargs <- list(i, j, ..., drop=drop)
#    show(list(sasgn.adtay.iargs=iargs, dx=safedim(x), dv=safedim(value)))

    svalue <- if (is(value, 'adtay')) {
                  value@val
              } else {
                  value
              }
    xargs <- append(append(list(x@val), iargs), list(value = svalue))
    r@val <- do.call('[<-', xargs)
    r@der <- lapply(1:r@order, function(i) {
        dvalue <- if (is(value, 'adtay')) {
                      value@der[[i]]
                  } else {
                      d_zeros(value)
                  }
        xargs <- append(append(list(r@der[[i]]), iargs), list(value = dvalue))
        do.call('[<-', xargs)
    })
    r
}
setMethod('[<-', signature(x='adtay'), `[<-.adtay`)


## `[<-.adtay.prom` <- function(x, i, j, ..., value) {
##     show("[<-.adtay.prom")
##     r <- adtay(x, ndd = value@der[[1]]@ndd, order = value@order)
##     do.call(`[<-.adtay`, list(x = r, i = i, j = j, ..., value = value))
## }
## setMethod('[<-', signature(value='adtay'), `[<-.adtay.prom`)
## #setMethod('[<-', signature(x='array'), `[<-.adtay.prom`)
## #setMethod('[<-', signature(x='matrix'), `[<-.adtay.prom`)


`[[<-.adtay` <- function(x, i, value) {
    r <- x
    iargs <- as.list(match.call(definition=function(...){}))[3]
    iargs <- lapply(iargs, evalind)
#    iargs <- list(i, ...)

    svalue <- if (is(value, 'adtay')) {
                  value@val
              } else {
                  value
              }
    xargs <- append(append(list(x@val), iargs), list(value = svalue))
    r@val <- do.call('[[<-', xargs)
    r@der <- lapply(1:r@order, function(i) {
        dvalue <- if (is(value, 'adtay')) {
                      value@der[[i]]
                  } else {
                      d_zeros(value)
                  }
        xargs <- append(append(list(r@der[[i]]), iargs), list(value = dvalue))
#        show(list(t=t,iargs=iargs,xargs=xargs))
        do.call('[[<-', xargs)
    })
    r
}
setMethod('[[<-', signature(x='adtay'), `[[<-.adtay`)

#adj_zeros_adtay <- function(x) {
#    show('a_zeros_adtay')
#    adtay(array(0, dim(x)), ndd = x@der[[1]]@ndd, order = x@order)
#}
#setMethod('adj_zeros', signature(x="adtay"), adj_zeros_adtay)

d_zeros_adtay <- function(x) {
    if (is.list(x)) {
        r <- lapply(x, d_zeros_adtay)
        return (r)
    }
    if (!is.numeric(x) && !is(x, 'adtay')) {
        return(x)
    }
#    show(list(d_zeros_adtay.x=class(x)))
    z <- if (is(x, 'adtay')) {
             x@val*0
         } else {
             x*0
         }
    adtay(z, order = adrGetOption('taylor-order'), ndd = globalNDD())
}

svd.adtay <- function(x, nu, nv, LINPACK) {
    z <- svd(x@val)
    r <- lapply(z, adtay)
    r$d@der[[1]] <- colSums(z$u * (x@der[[1]] %*% z$v))
    r
}
setMethod("svd", signature(x = "adtay"), svd.adtay)

range.adtay <- function(x, ..., na.rm = FALSE) {
    args <- list(...)
    if (length(args) > 0) {
        stop('range supported only for single argument x')
    }
    wm <- which.min(x@val)
    wM <- which.max(x@val)
    a <- c(wm,wM)
    r <- adtay(x@val[a])
    r@der[[1]] <-x@der[[1]][a]
    r
}
setMethod("range", signature(x = "adtay", na.rm = "ANY"), range.adtay)

solve.adtay <- function(a, b, tol = .Machine$double.eps, LINPACK = FALSE) {
    r <- adtay(solve(a@val, b@val, tol))
    dA <- a@der[[1]]
    db <- b@der[[1]]
    dim(db) <- c(numel(b@val), 1)
    rhs <- db -  dA %*% r@val
    dx <- solve(a@val, rhs, tol)
    r@der[[1]] <- dx
    r
}
solve.adtaynt <- function(a, b, tol = .Machine$double.eps, LINPACK = FALSE) {
    r <- adtay(solve(a, b@val, tol))
    db <- b@der[[1]]
    dim(db) <- c(numel(b@val), 1)
    dx <- solve(a, db, tol)
    r@der[[1]] <- dx
    r
}
solve.adtaytn <- function(a, b, tol = .Machine$double.eps, LINPACK = FALSE) {
    r <- adtay(solve(a@val, b, tol))
    dA <- a@der[[1]]
    rhs <- dA %*% -r@val
    dx <- solve(a@val, rhs, tol)
    r@der[[1]] <- dx
    r
}
setMethod("solve", signature(a = "adtay", b = "adtay"), solve.adtay)
setMethod("solve", signature(a = "ANY", b = "adtay"), solve.adtaynt)
setMethod("solve", signature(a = "adtay", b = "ANY"), solve.adtaytn)

convolve_adtay_adtay <- function(x, y, conj = TRUE, type = 'filter') {
    r <- adtay(convolve(x@val, y@val, conj, type))
    r@der[[1]] <- convolve(x@der[[1]], y@val, conj, type) + convolve(x@val, y@der[[1]], conj, type)
    r
}
convolve_adtay_x <- function(x, y, conj = TRUE, type = 'filter') {
    r <- adtay(convolve(x@val, y, conj, type))
    r@der[[1]] <- convolve(x@der[[1]], y, conj, type)
    r
}
convolve_x_adtay <- function(x, y, conj = TRUE, type = 'filter') {
    r <- adtay(convolve(x, y@val, conj, type))
    r@der[[1]] <- convolve(x, y@der[[1]], conj, type)
    r
}
setMethod("convolve", signature(x = "adtay", y = "adtay"), convolve_adtay_adtay)
setMethod("convolve", signature(x = "adtay"), convolve_adtay_x)
setMethod("convolve", signature(y = "adtay"), convolve_x_adtay)
