
setClass("advec", representation("ndd" = "numeric", "sz" = "vector", "data" = "array"))

## x1 <- new("advec", ndd = 10, sz = c(2,3), data = array(0, c(10, 2, 3)));
## x1
## class(x1)

new_advec <- function(x, ndd = 1) {
    if (is.null(x)) x <- 0
    xdim <- safedim(x)
    new("advec", ndd = ndd, sz = xdim, data = array(0, c(xdim, ndd)));
}

## x2 <- new_advec(array(1, c(2, 3)), 10);
## x2

## x3 <- new_advec(array(1+1i, c(2, 3)), 3);
## x3

advec <- function(x, ndd = 1) {
    new_advec(x, ndd)
}

rand_advec <- function(x, ndd = 1) {
    new("advec", ndd = ndd, sz = dim(x), data = array(rnorm(1:ndd*prod(dim(x))), c(dim(x), ndd)));
}

is_advec <- is.advec <- function(x) {
    is(x, "advec")
}

is.na_advec <- function(x) {
    is.na(x@data)
}
setMethod("is.na", signature(x = "advec"), is.na_advec)

reprl_advec <- function(x) {
    list(class(x), x@ndd, x@sz, x@data)
}

## isadv <- is_advec(x1);
## isadv
## isadv <- is_advec(0);
## isadv
## isadv <- is_advec(c(2,3,3));
## isadv

## names(formals(new_advec))
## formals(new_advec)

ndd_advec <- function(x) {
    x@ndd;
}

data_advec <- function(x) {
    x@data;
}

length_advec <- function(x) {
    prod(x@sz)
}
setMethod("length", c("advec"), `length_advec`)

dim_advec <- function(x) {
    x@sz;
}
setMethod("dim", c("advec"), `dim_advec`)

`dim<-_advec` <- function(x, value) {
    dim(x@data) <- c(value, x@ndd);
    x@sz <- value;
    x
}
setMethod("dim<-", c("advec"), `dim<-_advec`)

`isscalar_advec` <- function(x) {
    prod(x@sz) == 1
}
adr_isscalar <- function(x) {
    if (is(x, 'advec')) {
        isscalar_advec(x)
    } else {
        prod(dim(x)) == 1
    }
}

#drop_advec <- function(x) {
#    if (isscalar_advec(x))
#        x@sz <- NULL
#    x
#}
#setMethod("drop", c("advec"), `drop_advec`)

getdd <- function(x, i) {
    if (i > 1) {
        stop('invalid index')
    }
    x
}
setdd <- function(x, i, dd) {
    if (i > 1) {
        stop('invalid index')
    }
    if (!equals(safedim(x), safedim(y))) {
        stop('invalid size')
    }
    dd
}

getdd_advec <- function(x, i) {
    selargs <- as.list(array(TRUE,c(length(x@sz)+2)))
    selargs[[1]] <- x@data
    selargs[[length(x@sz)+2]] <- i
    dd <- do.call(`[`, selargs)
    dim(dd) <- x@sz
    dd
}
setGeneric("getdd", function(x, i) {standardGeneric("getdd")})
setMethod("getdd", signature(x = "advec"), getdd_advec)

setdd_advec <- function(x, i, dd) {
    selargs <- as.list(array(TRUE,c(length(x@sz)+3)))
    selargs[[1]] <- x@data
    selargs[[length(x@sz)+2]] <- i
    selargs[[length(x@sz)+3]] <- dd
    x@data <- do.call(`[<-`, selargs)
    x
}
setGeneric("setdd", function(x, i, dd) {standardGeneric("setdd")})
setMethod("setdd", signature(x = "advec"), setdd_advec)

## ndd_advec(x1)

## getdd_advec(x2, 1)
## x4 = setdd_advec(x2, 5, array(17,c(2,3)))
## getdd_advec(x2, 5)
## getdd_advec(x4, 5)


#`+_advec` <- function(x, y) {
#    r <- x
#    r@data <- x@data + y@data
#    r
#}

rdata_advec <- function(x, y) {
    if (prod(safedim(x)) == 1 && prod(dim_advec(y)) != 1) {
        x <- repmat(x, dim_advec(y));
    }
    rdim = c(ones(c(1, length(y@sz))), y@ndd);
    if (prod(y@sz) == 0) {
        rdim[[1]] <- 0
    }
    x <- as.array(x)
    dim(x) = c(safedim(x), 1);
    repmat(x, rdim)
}

isscalar_advec <- function(x) {
    prod(x@sz) == 1
}

repmat <- function(x, dim) kronecker(array(1, dim), x)
repmat_advec <- function(x, dim) {
    if (length(x@sz) < length(dim)) {
        x@sz <- c(x@sz, seq(1,1,length.out=length(dim) - length(x@sz)))
        dim(x@data) <- c(x@sz, x@ndd)
    }
    rdim = c(dim, 1)
    x@data <- repmat(x@data, rdim)
    x@sz <- x@sz * dim
    x
}
setGeneric("repmat", function(x, dim) {standardGeneric("repmat")})
setMethod("repmat", signature(x = "advec"), repmat_advec)


kronecker_advec <- function(X, Y, ...) {
    stop('not implemented')
    r <- X
    r@data <- kronecker(X@data, Y@data, ...)
    r@sz <- c(X@sz, Y@sz)
    r
}
kronecker_advecs <- function(X, Y, ...) {
    stop('not implemented')
    r <- X
    r@data <- kronecker(X@data[[1]], Y, ...)
    r@sz <- c(X@sz, safedim(Y))
    r
}
kronecker.sadvec <- function(X, Y, ...) {
    r <- Y
    r@data <- kronecker(X, Y@data, ...)
    xdim <- safedim(X)
    ydim <- Y@sz
    mlen <- max(length(xdim), length(ydim))
    if (length(xdim)<mlen)
        xdim[length(xdim):mlen] <- 1
    if (length(ydim)<mlen)
        ydim[length(ydim):mlen] <- 1
    r@sz <- safedim(X) * Y@sz
    dim(r@data) <- c(r@sz, r@ndd)
    r
}
setMethod("kronecker", signature(X = "advec", Y = "advec"), kronecker_advec)
setMethod("kronecker", signature(X = "advec"), kronecker_advecs)
setMethod("kronecker", signature(Y = "advec"), kronecker.sadvec)


outer_advec <- function(X, Y, ...) {
    r <- X
    r@data <- outer(X@data, Y@data, ...)
    r@sz <- c(X@sz, Y@sz)
    r
}
outer_advecs <- function(X, Y, ...) {
    r <- X
    r@data <- outer(X@data, Y, ...)
    r@sz <- c(X@sz, safedim(Y))
    r
}
outer.sadvec <- function(X, Y, ...) {
    r <- Y
    r@data <- outer(X, Y@data, ...)
    r@sz <- c(safedim(X), Y@sz)
    r
}
setMethod("outer", signature(X = "advec", Y = "advec"), outer_advec)
setMethod("outer", signature(X = "advec"), outer_advecs)
setMethod("outer", signature(Y = "advec"), outer.sadvec)


adr_reshape_advec <- function(x, sz) {
    rdim = c(sz, x@ndd)
    dim(x@data) <- rdim
    x@sz <- sz
    x
}
setMethod("adr_reshape", signature(x = "advec"), adr_reshape_advec)

scx_advec <- function(x, y) {
    if (is_advec(x)) {
        ydim = safedim(y);
        if (isscalar_advec(x)) {
            x <- repmat_advec(x, ydim);
        }
    }
    x
}

arith_advec <- function(e1, e2) {
    if (missing(e2)) {
        r <- e1
        r@data <- callGeneric(e1@data)
        return(r)
    }
    e1 <- scx_advec(e1, e2);
    e2 <- scx_advec(e2, e1);
    if (is_advec(e1) && is_advec(e2)) {
        r <- e1
        if (length(e1@data) != length(e2@data)) {
            stop(sprintf(paste('dimension error:',
                               paste(safedim(e1@data), collapse=','), paste(safedim(e2@data), collapse=','),
                               sep=' ', collapse='')))
        }
        dim(e2@data) <- safedim(e1@data)
        r@data <- callGeneric(e1@data, e2@data)
    } else if (is_advec(e1)) {
        r <- e1;
        rd <- rdata_advec(e2, e1)
        if (prod(dim(rd)) != 0) {
            dim(e1@data) <- dim(rd)
            r@data <- callGeneric(e1@data, rd);
        } else {
            r <- advec(rd, e1@ndd)
        }
    } else {
        r <- e2;
        rd <- rdata_advec(e1, e2)
        if (prod(dim(rd)) != 0) {
            dim(e2@data) <- dim(rd)
            r@data <- callGeneric(rd, e2@data);
        } else {
            r <- advec(rd, e2@ndd)
        }
    }
    r
}

setMethod(Arith, signature(e1="advec", e2="advec"),   arith_advec)
setMethod(Arith, signature(e1="advec"), arith_advec)
setMethod(Arith, signature(e2="advec"), arith_advec)

redMode <- 3

mtimesdd_advec <- function(x, y) {
    r <- x
    dim(x@data) <- c(size(x), x@ndd)
    dim(y@data) <- c(size(y), x@ndd)
    r@sz <- c(size(x)[1], size(y)[2])
    x@data <- aperm(x@data, c(1, 3, 2))
    dim(x@data) <- c(size(x)[1]*x@ndd, size(x)[2])
    dim(y@data) <- c(size(y)[1], size(y)[2]*x@ndd)
    r@data <- x@data %*% y@data
    dim(r@data) <- c(size(x)[1], x@ndd, size(y)[2], x@ndd)
    r@data <- aperm(r@data, c(1, 3, 2, 4))
    if (redMode == 1) {
        # diagonal
        dim(r@data) <- c(prod(r@sz), x@ndd * x@ndd)
        r@data <- as.array(r@data[ TRUE, seq(1, x@ndd*x@ndd, x@ndd) ])
    } else if (redMode == 2) {
        r@data <- aperm(r@data, c(1, 2, 4, 3))
        # sum
        dim(r@data) <- c(prod(r@sz) * x@ndd, x@ndd)
        r@data <- as.array(rowSums(r@data))
    } else if (redMode == 3) {
        # slice
        r@data <- as.array(r@data[,,1,])
    }
    dim(r@data) <- c(r@sz, x@ndd)
    r
}
mtimesdv_advec <- function(x, y) {
    r <- x
    dim(x@data) <- c(size(x), x@ndd)
    dim(y) <- size(y)
    r@sz <- c(size(x)[1], size(y)[2]);
    x@data <- aperm(x@data, c(1, 3, 2));
    dim(x@data) <- c(size(x)[1]*x@ndd, size(x)[2]);
    r@data <- as.array(x@data %*% y);
    dim(r@data) <- c(size(x)[1], x@ndd, size(y)[2]);
    r@data <- aperm(r@data, c(1, 3, 2));
    r
}
mtimesvd_advec <- function(x, y) {
    r <- y;
    r@sz <- c(size(x)[1], size(y)[2]);
    dim(y@data) <- c(size(y)[1], size(y)[2]*r@ndd);
    r@data <- as.array(x %*% y@data)
    dim(r@data) <- c(r@sz, r@ndd);
    r
}

setMethod("%*%", signature(x = "advec", y = "advec"), mtimesdd_advec)
setMethod("%*%", signature(x = "advec"), mtimesdv_advec)
setMethod("%*%", signature(y = "advec"), mtimesvd_advec)
#setMethod("%*%", signature(x = "advec", y = "dgeMatrix"), mtimesdv_advec)
#setMethod("%*%", signature(x = "dgeMatrix", y = "advec"), mtimesvd_advec)
#setMethod("%*%", signature(x = "advec", y = "dgCMatrix"), mtimesdv_advec)
#setMethod("%*%", signature(x = "dgCMatrix", y = "advec"), mtimesvd_advec)

mtimes_advec <- function(x, y) {
    x %*% y
}
adr_mtimes <- function(x, y) {
    if (is(x, 'advec') || is(y, 'advec')) {
        mtimes_advec(x, y)
    } else {
        x %*% y
    }
}


evalind <- function(x) {
    if (is.symbol(x)) {
        nm <- as.character(x)
        if (nm == "") {
            TRUE
        } else {
            eval.parent(x, 3)
        }
    } else if (is.expression(x) || is.call(x)) {
        eval.parent(x, 3)
    } else {
        x
    }
}

`[_advec` <- function(x, i, j, ..., drop=TRUE) {
    mcg <- as.list(match.call(definition=function(...){}))
    al <- lapply(mcg[3:length(mcg)], evalind)
#    show(list(subsref_advec.inds=al, mcg=mcg))
    nargin <- length(mcg) -2 - (if ('drop' %in% names(mcg)) 1 else 0)
    if (nargin != 1 && nargin != length(x@sz)) {
        stop('incorrect number of dimensions')
    }
    if (nargin == 1 && length(x@sz) > 1) {
        dim(x@data) = c(prod(x@sz), x@ndd);
    }
    al <- append(al, list(TRUE))
    args <- append(list(x=x@data), al)
    res <- do.call("[", args)
    x@data <- as.array(res)
    ddim <- dim(x@data)
    if (length(ddim) > 1) {
        if (x@ndd > 1) {
            x@sz <- as.numeric(ddim[1:(length(ddim)-1)])
        } else {
            x@sz <- as.numeric(ddim)
        }
    } else {
        if (x@ndd == 1) {
            x@sz <- ddim[[1]]
        } else {
            x@sz <- c(1)
        }
    }
    dim(x@data) <- c(x@sz, x@ndd)
    x
}
setMethod('[', signature(x='advec'), `[_advec`)

getnsel <- function(s) {
    if (is.logical(s)) sum(s) else length(s)
}

`[<-_advec` <- function(x, i, j, ..., value) {
    mcg <- as.list(match.call(definition=function(...){}))
    al <- lapply(mcg[3:(length(mcg)-1)], evalind)
    nargin <- length(mcg) -3
    if (nargin != 1 && nargin != length(x@sz)) {
        stop('incorrect number of dimensions')
    }
    if (nargin == 1 && length(x@sz) > 1) {
        dim(x@data) = c(prod(x@sz), x@ndd);
    }
    nindexed  <- prod(sapply(al, getnsel))
    al <- append(al, TRUE)
    if (is_advec(value)) {
        rhsd = value@data;
        if (nindexed > prod(value@sz)) {
            s <- nindexed / prod(value@sz)
            dim(rhsd) <- c(prod(value@sz), value@ndd)
            rhsd <- repmat(rhsd, c(s, 1));
        }
    } else {
        rhsd = value;
    }
    args <- append(append(list(x=x@data), al), list(value=rhsd)) #FIXME
    x@data <- do.call("[<-", args)
    dim(x@data) = c(x@sz, x@ndd)
    x
}
setMethod('[<-', signature(x='advec'), `[<-_advec`)

`[[_advec` <- function(x, i, j, ...) {
    mcg <- as.list(match.call(definition=function(...){}))
    al <- lapply(mcg[3:length(mcg)], evalind)
    do.call(`[_advec`, append(list(x), al))
}
setMethod('[[', signature(x='advec'), `[[_advec`)

`[[<-_advec` <- function(x, i, j, ..., value) {
    mcg <- as.list(match.call(definition=function(...){}))
    al <- lapply(mcg[3:(length(mcg))], evalind)
    do.call(`[<-_advec`, append(list(x), al))
}
setMethod('[[<-', signature(x='advec'), `[[<-_advec`)


#adj_zeros_advec <- function(x) {
#    show('a_zeros_advec')
#    advec(array(0, x@sz), x@ndd)
#}
#setMethod('adj_zeros', signature("advec"), adj_zeros_advec)

# does not work, while getMethod finds the method, it is nor actually dispatched to
## subcreate_advec <- function(x, i, j, ..., value) {
##     show('subcreate_advec')
##     x <- advec(x, value@ndd)
##     x[i,j] <- value
##     x
## }
## setMethod('[[<-', signature(value = "advec"), subcreate_advec)

solvedd_advec <- function(a, b, ...) {
    print('solve DD advec')
    r <- a %*% b
    print(dim(r))
    r
}
solvedv_advec <- function(a, b, ...) {
    print('solve DV advec')
    r <- a %*% b
    print(dim(r))
    r
}
solvevd_advec <- function(a, b, ...) {
    r <- b
    rhs <- b@data
    dim(rhs) <- c(dim(b)[1], dim(b)[2]*b@ndd)
    sol <- solve(a, rhs, ...)
    dim(sol) <- c(dim(b)[1], dim(b)[2], b@ndd)
    r@data <- sol
    r
}
setMethod("solve", signature(a = "advec", b = "advec"), solvedd_advec)
setMethod("solve", signature(a = "advec", b = "matrix"), solvedv_advec)
setMethod("solve", signature(a = "matrix", b = "advec"), solvevd_advec)

isvector_advec <- function(a) {
    r <- FALSE
    if (length(dim(a)) == 2) {
        if (dim(a)[1] == 1 || dim(a)[2] == 1) {
            r <- TRUE
        }
    } else if (length(dim(a)) == 1) {
        r <- TRUE
    }
    r
}

sum_advec <- function(x, ..., na.rm = FALSE) {
    r <- x

    r@data <- as.array(colSums(x@data, na.rm = na.rm, dim = length(x@sz)))

    res <- lapply(list(...), function(i) {
        r@data <<- r@data + as.array(colSums(i@data, na.rm = na.rm, dim = length(i@sz)))
    })

    dim(r) <- 1

    r
}
setMethod("sum", signature(x = "advec"), sum_advec)

diff_advec <- function(x, lag = 1, differences = 1, ... ) {
    r <- x

    if (isvector_advec(x)) {
        dim(r@data) <- c(x@sz[1], x@ndd)
        r@data <- as.array(diff(r@data, lag, differences, ...))
        r@sz[1] <- x@sz[1] - differences*lag
    } else {
        dim(r@data) <- c(x@sz[1], x@sz[2] * x@ndd)
        r@data <- as.array(diff(r@data, lag, differences, ...))
        dim(r@data) <- c(x@sz[1] - differences*lag, x@sz[2], x@ndd)
        dim(r) <- c(x@sz[1] - differences*lag, x@sz[2])
    }
    
    r
}
setMethod("diff", signature(x = "advec"), diff_advec)

colSums_advec <- function(x, na.rm = FALSE, dims = 1) {
    r <- x
    ncx <- if (length(x@sz) > 1) prod(x@sz[2:length(x@sz)]) else 1
    dim(r@data) <- c(x@sz[[1]], ncx * x@ndd)
    r@data <- as.array(colSums(r@data, na.rm = na.rm, dim = 1))
    dim(r@data) <- c(ncx, x@ndd)
    r@sz <- ncx
    r
}
setMethod("colSums", signature(x = "advec"), colSums_advec)

colMeans_advec <- function(x, na.rm = FALSE, dims = 1) {
    r <- x
    ncx <- if (length(x@sz) > 1) prod(x@sz[2:length(x@sz)]) else 1
    dim(r@data) <- c(x@sz[[1]], ncx * x@ndd)
    r@data <- as.array(colMeans(r@data, na.rm = na.rm, dim = 1))
    dim(r@data) <- c(ncx, x@ndd)
    r@sz <- ncx
    r
}
setMethod("colMeans", signature(x = "advec"), colMeans_advec)

convolve_advec_advec <- function(x, y, conj = TRUE, type = 'filter') {
    r <- z
    stop('not run')
    r
}
as.nddmat <- function(x) {
    array(x@data, c(prod(x@sz), x@ndd))
}
convolve_advec_x <- function(x, y, conj = TRUE, type = 'filter') {
    r <- x
    dim(y) <- c(length(y), 1)
    dr <- adr_convolve(as.nddmat(x), y, conj, type)
    r@sz <- safedim(convolve(if (length(x@sz)>1) array(0, x@sz) else rep(0,x@sz), y, conj, type))
    r@data <- adr_reshape(dr, c(r@sz, r@ndd))
    r
}
convolve_x_advec <- function(x, y, conj = TRUE, type = 'filter') {
    r <- y
    dim(x) <- c(length(x), 1)
    dr <- adr_convolve(x, as.nddmat(y), conj, type)
    r@sz <- safedim(convolve(x, if (length(y@sz)>1) array(0, y@sz) else rep(0,y@sz), conj, type))
    r@data <- adr_reshape(dr, c(r@sz, r@ndd))
    r
}
setMethod("convolve", signature(x = "advec", y = "advec"), convolve_advec_advec)
setMethod("convolve", signature(x = "advec"), convolve_advec_x)
setMethod("convolve", signature(y = "advec"), convolve_x_advec)

fft_advec <- function(z, inverse = FALSE) {
    r <- z

    if (isvector_advec(z)) {
        dim(r@data) <- c(prod(z@sz), z@ndd)
        r@data <- mvfft(r@data, inverse)
        dim(r@data) <- dim(z@data)
    } else {
        r <- 0
        stop('not implemented')
    }
    
    r
}
setMethod("fft", signature(z = "advec"), fft_advec)

mvfft_advec <- function(z, inverse = FALSE) {
    r <- z

    dim(r@data) <- c(z@sz[[1]], prod(z@sz[-1]) * z@ndd)
    r@data <- mvfft(r@data, inverse)
    dim(r@data) <- dim(z@data)
    
    r
}
setMethod("mvfft", signature(z = "advec"), mvfft_advec)

aperm_advec <- function(a, perm) {
    r <- a
    r@sz   <- r@sz[perm]
    r@data <- aperm(r@data, c(perm, length(r@sz)+1))
    r
}
setMethod("aperm", signature(a = "advec"), aperm_advec)

t_advec <- function(x) {
    r <- x

    if (length(x@sz) == 1) {
        r@sz = c(x@sz, 1)
    }
    dim(r@data) <- c(r@sz, x@ndd)
    r@data <- aperm(r@data, c(2, 1, 3))
    r@sz = c(r@sz[[2]], r@sz[[1]])

    r
}
setMethod("t", signature(x = "advec"), t_advec)

rep_advec <- function(x, times=1, length.out=NA, each=1) {
    r <- x
    len <- prod(r@sz)
    dim(r@data) <- c(len, r@ndd)
    if (is.na(length.out)) {
        r@sz <- len*times*each
        r@data <- array(rep(r@data, each=each), c(len*each, x@ndd))
        r@data <- as.array(kronecker(rep(1, times), r@data))
    } else {
        if (length.out>0) {
            r@sz <- length.out
            r@data <- array(rep(r@data, each=each), c(len*each, x@ndd))
            r@data <- as.array(kronecker(rep(1, ceiling(length.out/each)), r@data))
            r@data <- as.array(r@data[1:length.out,])
        } else {
            r@sz <- 0
            r@data <- array(0, c(0, x@ndd))
        }
    }
    dim(r@data) <- c(r@sz, r@ndd)
    r
}
setMethod("rep", signature(x = "advec"), rep_advec)

rev_advec <- function(x) {
    r <- x

    if (length(x@sz) > 1) {
        dim(r@data) <- c(prod(x@sz), x@ndd)
        r@sz = prod(x@sz)
    }
    r@data <- as.array(r@data[seq(r@sz, 1, -1),])

    r
}
setMethod("rev", signature(x = "advec"), rev_advec)

Re_advec <- function(z) {
    r <- z
    r@data <- Re(r@data)
    r
}
setMethod("Re", signature(z = "advec"), Re_advec)

Im_advec <- function(z) {
    r <- z
    r@data <- Im(r@data)
    r
}
setMethod("Im", signature(z = "advec"), Im_advec)

Conj_advec <- function(z) {
    r <- z
    r@data <- Conj(r@data)
    r
}
setMethod("Conj", signature(z = "advec"), Conj_advec)

as.double_advec <- function(x, ...) {
    r <- x
    r
}
setMethod("as.double", signature(x = "advec"), as.double_advec)

as.matrix_advec <- function(x, ...) {
    r <- x
    if (length(x@sz) > 2) {
        if (prod(x@sz[3:length(x@sz)]) == 1) {
        } else {
            # warning
        }
        r@data <- x@data[,,1]
        r@sz <- x@sz[1:2]
    } else if (length(x@sz) == 2) {
    } else if (length(x@sz) == 1) {
        r@data <- adr_reshape(x@data, c(x@sz, 1, x@ndd))
        r@sz <- c(x@sz, 1)
    } else {
        r@data <- adr_reshape(x@data, c(0, 0, x@ndd))
        r@sz <- c(0, 0)
    }
    r
}
setMethod("as.matrix", signature(x = "advec"), as.matrix_advec)

as.vector_advec <- function(x, mode = "any") {
    r <- x
    r
}
setMethod("as.vector", signature(x = "advec"), as.vector_advec)

sub2ind <- function(sz, ...) {
    inds = list(...)
    rs <- array(0, length(inds[[1]]))
    f <- 1
    for (k in 1:length(inds)) {
        rs <- rs + f * (inds[[k]] - 1)
        f <- f * sz[[k]]
    }
    rs <- rs + 1
    rs
}

diag_advec <- function(x, nrow, ncol) {
    r <- x
    if (missing(nrow) && missing(ncol) && length(x@sz) > 1) {
        p = min(dim(x)[[1]], dim(x)[[2]])
        r@data <- array(0, c(p, x@ndd))
        di <- sub2ind(x@sz, 1:p, 1:p)
        dim(x@data) <- c(prod(x@sz), x@ndd)
        r@sz <- c(p)
        r@data[1:p,] <- x@data[di,]
        r@data
    } else {
        p = length(x)
        if (missing(ncol)) {
            ncol <- p
        }
        if (missing(nrow)) {
            nrow <- p
        }
        r@data <- array(0, c(nrow * ncol, x@ndd))
        p = min(nrow, ncol)
        di <- sub2ind(c(nrow, ncol), 1:p, 1:p)
        r@data[di,] <- x@data
        dim(r@data) <- c(nrow, ncol, x@ndd)
        r@sz = c(nrow, ncol)
    }
    r
}
setMethod("diag", signature(x = "advec"), diag_advec)

c_advec <- function(x, ...) {
#    show('c_advec')
    args <- append(list(x), list(...))
    r <- x
#    show(list(x=x, args=args))
    r@sz <- sum(vapply(args, function(x) prod(x@sz), FUN.VALUE=0))
#    show(r@sz)
    r@data <- as.array(do.call(rbind, lapply(args, function(v) adr_reshape(v@data, c(prod(v@sz), v@ndd)))))
    dim(r@data) <- c(r@sz, x@ndd)
    r
}
setMethod("c", signature(x = "advec"), c_advec)

dpartial_crbind2_x <- function(handle, x, y, ...) {
    rt <- handle(array(1, x@sz), array(0, y@sz), ...)
    dr <- safedim(rt)
    rt <- c(rt)
    attr(rt, 'sz') <- dr
    rt
}
dpartial_crbind2_y <- function(handle, x, y, ...) {
    rt <- handle(array(0, x@sz), array(1, y@sz), ...)
    dr <- safedim(rt)
    rt <- c(rt)
    attr(rt, 'sz') <- dr
    rt
}

cbind2_advec <- function(x, y, ...) {
    rtx <- dpartial_crbind2_x(cbind, x, y, ...)
    rty <- dpartial_crbind2_y(cbind, x, y, ...)
#    show(rtx)
#    show(rty)
#    show(c(x))
#    show(c(y))
    r <- advec(rtx, x@ndd)
    rhs1 <- adr_reshape(x@data, c(prod(x@sz), x@ndd))
#    show(rhs1)
#    show(r)
#    show(r@data[rtx!=0,])
    r@data[rtx!=0,] <- rhs1
#    show(r@data)
#    show(r@data[rty!=0,])
#    show(y)
    rhs2 <- adr_reshape(y@data, c(prod(y@sz), y@ndd))
#    show(rhs2)
    r@data[rty!=0,] <- rhs2
    dim(r) <- attr(rtx, 'sz')
    r
}
cbind2_advecs <- function(x, y, ...) {
    r@data <- as.array(cbind(x@data, y))
    sy <- safedim(y)
    r@sz[[1]] <- x@sz[[1]] + sy[[1]]
    ncx <- if (length(x@sz) > 1) prod(x@sz[2:length(x@sz)]) else 1
    ncy <- if (length(sy) > 1) prod(sy[2:length(sy)]) else 1
    r@sz[[2]] <- max(c(ncx, ncy))
    r
}
cbind2.sadvec <- function(x, y, ...) {
                                        # y, but not x
    r@data <- as.array(cbind(x, y@data))
    sx <- safedim(x)
    r@sz[[1]] <- sx[[1]] + y@sz[[1]]
    ncx <- if (length(sx) > 1) prod(sx) else 1
    ncy <- if (length(y@sz) > 1) prod(y@sz[2:length(y@sz)]) else 1
    r@sz[[2]] <- max(c(ncx, ncy))
    r
}

#setGeneric("cbind2", function(x,y,...) {standardGeneric("cbind2")})
setMethod("cbind2", signature(x = "advec", y = "advec"), cbind2_advec)
setMethod("cbind2", signature(x = "advec"), cbind2_advecs)
setMethod("cbind2", signature(y = "advec"), cbind2.sadvec)

rbind2_advec <- function(x, y, ...) {
    rtx <- dpartial_crbind2_x(rbind, x, y, ...)
    rty <- dpartial_crbind2_y(rbind, x, y, ...)
#    show(rtx)
#    show(rty)
#    show(c(x))
#    show(c(y))
    r <- advec(rtx, x@ndd)
    rhs1 <- adr_reshape(x@data, c(prod(x@sz), x@ndd))
#    show(rhs1)
#    show(r)
#    show(r@data[rtx!=0,])
    r@data[rtx!=0,] <- rhs1
#    show(r@data)
#    show(r@data[rty!=0,])
#    show(y)
    rhs2 <- adr_reshape(y@data, c(prod(y@sz), y@ndd))
#    show(rhs2)
    r@data[rty!=0,] <- rhs2
    dim(r) <- attr(rtx, 'sz')
    r
}
rbind2_advecs <- function(x, y, ...) {
    r <- x
    r@data <- as.array(rbind(x@data, y))
    sy <- safedim(y)
    r@sz[[1]] <- x@sz[[1]] + sy[[1]]
    ncx <- if (length(x@sz) > 1) prod(x@sz[2:length(x@sz)]) else 1
    ncy <- if (length(sy) > 1) prod(sy[2:length(sy)]) else 1
    r@sz[[2]] <- max(c(ncx, ncy))
    r
}
rbind2.sadvec <- function(x, y, ...) {
                                        # y, but not x
    r <- y
    r@data <- as.array(rbind(x, y@data))
    sx <- safedim(x)
    r@sz[[1]] <- sx[[1]] + y@sz[[1]]
    ncx <- if (length(sx) > 1) prod(sx) else 1
    ncy <- if (length(y@sz) > 1) prod(y@sz[2:length(y@sz)]) else 1
    r@sz[[2]] <- max(c(ncx, ncy))
    r
}

#setGeneric("rbind2", function(x,y,...) {standardGeneric("rbind2")})
setMethod("rbind2", signature(x = "advec", y = "advec"), rbind2_advec)
setMethod("rbind2", signature(x = "advec"), rbind2_advecs)
setMethod("rbind2", signature(y = "advec"), rbind2.sadvec)

array_advec <- function(data, dim = length(data), dimnames = NULL) {
    r <- data
    r@sz <- dim
    dim(r@data) <- prod(data@sz, data@ndd)
    r@data <- array(data@data[1:prod(data@sz),], c(dim, r@ndd))
    r
}
setMethod("array", signature(data = "advec"), array_advec)
