% File adrDiffFor.Rd
\name{adrDiffFor}
\alias{adrDiffFor}
%\alias{admDiffFor}

\title{Differentiate R code in FM of AD}
\description{
  Differentiate R code in forward mode (FM) of automatic differentiation
  (AD).
}
\usage{
adrDiffFor(func, arguments, seed = 1, options = adrOptions())
}
\arguments{
  \item{func}{a function.}
  \item{arguments}{the function call arguments.}
  \item{seed}{the seed matrix.}
  \item{options}{an options structure.}
}
\value{
  The Jacobian matrix of the call \code{do.call(f, args)}, implicitely
  multiplied by \code{seed}.

  The \code{seed} defaults to 1 which means the fitting identity matrix.

  The most important option is \code{independents}, which defaults to
  1. When calling \code{adrOptions} it can be abbreviated with \code{i}.
  
  The second most important option is \code{vectormode}, which can be
  used to force vector mode or scalar mode, and not rely on the
  automatic behaviour, which is controlled by
  \code{vectormode-switchover}.

}
\seealso{
  \code{\link{adrDiffFD}}.
  \code{\link{adrOptions}}.
}
\examples{
## Differentiate f(x) = x*x = x^2 at point x=2
adrDiffFor(function(x) x*x, list(2))

f <- function(x) 3*sqrt(exp(x))

## Differentiate f(x) at point x=2
adrDiffFor(f, list(2))
adrDiffFD(f, list(2))

x <- 1:4

adrDiffFor(f, list(x), seed = 1)
adrDiffFor(f, list(x), seed = diag(4))

## Differentiate function f(x) at point x, all directions at once
adrDiffFor(f, list(x), seed = matrix(1, 4, 1))
adrDiffFD(f, list(x), seed = array(1, c(4, 1)))

y <- 2:5
f <- function(x,y) 3*sqrt(x*exp(y))

## Differentiate function f(x,y) at point (x,y), w.r.t. x
adrDiffFor(f, list(x, y), seed = matrix(1, 4, 1))

## Differentiate function f(x,y) at point (x,y), w.r.t. x and y
adrDiffFor(f, list(x, y), seed = matrix(1, 8, 1), options = adrOptions(i=1:2))

## Differentiate function f(x,y) at point (x,y), w.r.t. y alone
adrDiffFor(f, list(x, y), seed = matrix(1, 4, 1), options = adrOptions(i=2))
}
\author{
  Johannes Willkomm
}
\keyword{ad}
\keyword{fm}
\keyword{adr}
\keyword{automatic}
\keyword{differentiation}
\keyword{automatic differentiation}
\keyword{differentiate}
\keyword{derivative}
\keyword{forward}
\keyword{mode}
\keyword{forward mode}
