context("adrfor/test-sqrt-babylonian.R")

babylonian <- source('../../inputs/r/functions/babylonian-rec.R', keep.source=TRUE)$value
environment(babylonian) <- environment()

f <- function(x) {
    babylonian(x, 1)
}

test_that("babylonian sqrt function", {
    
    x <- 4
    
    options = adrOptions(i = 1)
    print(sqrt(x))
    print(f(x))
    print(adrDiffFor(f, list(x)))
    print(adrDiffRev(f, list(x)))
    adTest(f, list(x), options = options)

})

test_that("babylonian sqrt function", {
    
    x <- 14343434.23323
    
    options = adrOptions(i = 1, fdStep = 1e-8 * x)
    print(sqrt(x))
    print(f(x))
    print(adrDiffFor(f, list(x)))
    print(adrDiffRev(f, list(x)))
    adTest(f, list(x), options = options)

})
