context("adrfor/test-sqrt.R")

test_that("adrFor works on the sqrt function", {
    f <- function(x) {
        sqrt(x)
    }
    relerr <- adTest(f, list(0.2))
    expect_true(relerr[[1]] < 1e-7)
    expect_true(relerr[[2]] < 1e-14)
})

test_that("adrFor works on the sqrt function (by handle)", {
    f <- function(x, h) {
        h(x)
    }
    options = adrOptions(i = 1)
    relerr <- adTest(f, list(0.2, sqrt), options = options)
    expect_true(relerr[[1]] < 1e-7)
    expect_true(relerr[[2]] < 1e-14)
})

test_that("adrFor works on the sqrt function (by handle) (II)", {
    f <- function(x, hf) {
        hf(x)
    }
    options = adrOptions(i = 1)
    relerr <- adTest(f, list(0.2, sqrt), options = options)
    expect_true(relerr[[1]] < 1e-7)
    expect_true(relerr[[2]] < 1e-14)
})

test_that("adrFor works on the root newton iteration", {
    rootnewt <- function(x, n, y0) {
        if (abs(x - y0^n) < 1e-14) {
            z <- y0
        } else {
            z <- rootnewt(x, n, ((n - 1) * y0^n + x) / (n * y0^(n-1)))
        }
        z
    }
    f <- function(x, n, y0) {
        rootnewt(x, n, y0)
    }
    options = adrOptions(i = 1, trace = 1)
    print(sqrt(0.2))
    print(f(0.2, 2, 1))
    relerr <- adTest(rootnewt, list(0.2, 2, 1), options = options)
    expect_true(relerr[[1]] < 1e-7)
    expect_true(relerr[[2]] < 1e-14)

    print(0.2^(1/3))
    print(f(0.2, 3, 1))
    relerr <- adTest(rootnewt, list(0.2, 3, 1), options = options)
    expect_true(relerr[[1]] < 1e-7)
    expect_true(relerr[[2]] < 1e-14)
})

test_that("adrFor works on the root newton iteration", {
#    globalADROptions('loglevels', c(getADROption('loglevels'), list('diffText:result' =  2)))
#    globalADROptions('loglevels', c(getADROption('loglevels'), list('dsource:result' =  2)))
    
    rootnewt <- function(x, n, y0) {
        y <- y0
        while (abs(x - y^n) > 1e-14) {
            y <- ((n - 1) * y^n + x) / (n * y^(n-1))
        }
        y
    }
    f <- function(x, n, y0) {
        rootnewt(x, n, y0)
    }
    options = adrOptions(i = 1)
    print(sqrt(0.2))
    print(f(0.2, 2, 1))
    relerr <- adTest(rootnewt, list(0.2, 2, 1), options = options)
    expect_true(relerr[[1]] < 1e-7)
    expect_true(relerr[[2]] < 1e-14)

    print(0.2^(1/3))
    print(f(0.2, 3, 1))
    relerr <- adTest(rootnewt, list(0.2, 3, 1), options = options)
    expect_true(relerr[[1]] < 1e-7)
    expect_true(relerr[[2]] < 1e-14)
})
