
options(digits=14)

adrTestFDTol <- function(options=list()) {
    if (!is.null(options$cmpadfdtol))
        options$cmpadfdtol
    else
        adrGetOption('cmpadfdtol', 1e-5)
}

xtest_that <- function(...) {}

testADAndFuncResults <- function(func, args, options, seed = NULL, modes = 'frdt') {
    if (length(options$independents) == 0) {
        options$independents <- 1 # fixme here all now
    }
    if (is.null(options$vectormode)) {
        options$vectormode <- TRUE
        testADAndFuncResults(func, args, options, seed, modes = modes)
        options$vectormode <- FALSE
        testADAndFuncResults(func, args, options, seed, modes = modes)
        return(0);
    }
    if (is.null(seed)) {
        tnel <- do.call(totalNumel, args[options$independents])
        S1 <- matrix(rnorm(1:tnel), ncol = 1)+10
        testADAndFuncResults(func, args, options = options, seed = S1, modes = modes)
        S3 <- matrix(rnorm(1:(3*tnel)), ncol = 3)+10
        testADAndFuncResults(func, args, options = options, seed = S3, modes = modes)
    } else {
        relerr <- adTest(func, args, seed = seed, options = options, modes = modes)
        tol <- adrTestFDTol(options)
        if (!(relerr[[1]] < tol)) {
            print('AD-FD test failed!')
            show(relerr[[1]])
            show(attr(relerr, 'JFM'))
            show(attr(relerr, 'JFD'))
        }
        expect_true(relerr[[1]] < tol)
        expect_true(relerr[[2]] < 1e-13)
        expect_true(relerr[[3]] < 1e-13)
    }
}

testADAndFuncResultsSym <- function(func, args, options) {
    testADAndFuncResults(func, list(args[[1]], args[[2]]), options)
    testADAndFuncResults(func, list(args[[2]], args[[1]]), options)
    testADAndFuncResults(func, list(args[[1]], args[[1]]), options)
    testADAndFuncResults(func, list(args[[2]], args[[2]]), options)
}

numExpectations <- function(r1) {
    sapply(r1, function(x) {
        length(x$results)
    })
}

testExpHasPassed <- function(y) is(y, 'expectation_success')
testExpHasFailed <- function(y) is(y, 'expectation_failure')
testExpHasError  <- function(y) is(y, 'expectation_error')

testExpRec <- function(r1, count) {
    sapply(r1, function(x) {
        if (length(x$results)) {
            sum(sapply(x$results, function(y) {
                count(y)
            }))
        } else 0
    })
}
testExpOK    <- function(r1) testExpRec(r1, testExpHasPassed)
testExpFail  <- function(r1) testExpRec(r1, testExpHasFailed)
testExpError <- function(r1) testExpRec(r1, testExpHasError)

numTests <- function(r1) {
    length(r1)
}

testRec <- function(r1, count) {
    sum(sapply(r1, function(x) {
        if (length(x$results)) {
            rexp <- sum(sapply(x$results, function(y) {
                count(y)
            }))
        } else rexp <- 0
        rexp > 0
    }))
}

testOK    <- function(r1) testRec(r1, testExpHasPassed)
testFail  <- function(r1) testRec(r1, testExpHasFailed)
testError <- function(r1) testRec(r1, testExpHasError)

diffMatrix <- function(Jacs) {
    dm <- array(0,c(length(Jacs),length(Jacs)))
    colnames(dm) <- names(Jacs)
    rownames(dm) <- names(Jacs)
    for (i in 1:length(Jacs)) {
        if (i > 1) {
            for (j in 1:(i-1)) {
                if (any(is.na(Jacs[[i]]))
                    || any(is.na(Jacs[[j]]))
                    || any(is.infinite(Jacs[[i]]))
                    || any(is.infinite(Jacs[[j]]))) {
                    dm[[i,j]] = -1
                    if (prod(safedim(Jacs[[i]])) == 1 || prod(safedim(Jacs[[j]])) == 1) {
                    } else {
                        cat(paste('NAs produced:\n'))
                        show(Jacs[c(i,j)])
                    }
                } else
                    dm[[i,j]] = relmaxnorm(Jacs[[i]], Jacs[[j]])
            }
        }
    }
    dm
}

adTest <- function(handle, args, seed = 2, options = adrOptions(), modes = 'frdt', seedRev = 2) {

    jacs <- list()
    ress <- list()

    resf <- do.call(handle, args)

    if (prod(size(seed)) == 1) {
        ndd <- do.call(totalNumel, args[options$independents])
        eseed <- seed * eye(ndd)
    } else {
        eseed <- seed
    }
    if (prod(size(seedRev)) == 1) {
        nddRev <- totalNumel(resf)
        eseedRev <- seedRev * eye(nddRev)
    } else {
        eseedRev <- seedRev
    }
    if (grepl('f', modes)) {
        J <- adrDiffFor(handle, args, seed, options)
        jacs <- append(jacs, list(f = J[[1]]))
        ress <- append(ress, list(f = J[[2]]))
#        show(args)
#        show(J[[2]])
#        print('Jac dim')
#        show(size(J[[1]]))
        tnel <- do.call(totalNumel, args[options$independents])
        expect_true(size(J[[1]])[2] == size(eseed)[2])
        tnelo <- totalNumel(J[[2]])
#        print('Expected Jac dim')
#        show(c(tnelo, size(eseed)[2]))
        expect_true(size(J[[1]])[1] == tnelo)
    } else {
        jacs <- append(jacs, list(f = NaN))
        ress <- append(ress, list(f = NaN))
    }
    if (grepl('r', modes)) {
        adr_store(8) # clear stack
        expect_true(adr_store(2) == 0)
        J <- adrDiffRev(handle, args, seedRev, options)
        expect_true(adr_store(2) == 0)
        isErrResult <- if (is.null(attr(J, 'error'))) FALSE else TRUE
        expect_true(!isErrResult)
        if (!isErrResult) {
            jacs <- append(jacs, list(r = J[[1]]))
            ress <- append(ress, list(r = J[[2]]))
            tnel <- totalNumel(J[[2]])
            expect_true(tnel == totalNumel(resf))
#            show(dim(J[[1]]))
            expect_true(size(J[[1]])[1] == size(eseedRev)[1])
            tneli <- do.call(totalNumel, args[options$independents])
                                        #        print('Expected Jac dim')
                                        #        show(c(tnelo, size(eseed)[2]))
            expect_true(size(J[[1]])[2] == tneli)
        } else {
            jacs <- append(jacs, list(r = NaN))
            ress <- append(ress, list(r = NaN))
        }
    } else {
        jacs <- append(jacs, list(r = NaN))
        ress <- append(ress, list(r = NaN))
    }
    if (grepl('d', modes)) {
        J <- adrDiffFD(handle, args, seed, options)
        jacs <- append(jacs, list(d = J[[1]]))
        ress <- append(ress, list(d = J[[2]]))
        expect_true(size(J[[1]])[2] == size(eseed)[2])
        tnelo <- totalNumel(J[[2]])
        expect_true(size(J[[1]])[1] == tnelo)
    } else {
        jacs <- append(jacs, list(d = NaN))
        ress <- append(ress, list(d = NaN))
    }
    if (grepl('t', modes)) {
        J <- adrTaylorFor(handle, args, seed, options)
        jacs <- append(jacs, list(t = J[[1]]))
        ress <- append(ress, list(t = J[[2]]))
#        show(args)
#        show(J[[2]])
#        print('Jac dim')
#        show(size(J[[1]]))
        tnel <- do.call(totalNumel, args[options$independents])
        expect_true(size(J[[1]])[2] == size(eseed)[2])
        tnelo <- totalNumel(J[[2]])
#        print('Expected Jac dim')
#        show(c(tnelo, size(eseed)[2]))
        expect_true(size(J[[1]])[1] == tnelo)
    } else {
        jacs <- append(jacs, list(t = NaN))
        ress <- append(ress, list(t = NaN))
    }

    f <- function(Jtype) {
        J <- as.matrix(jacs[[Jtype]])
        if (any(is.nan(J))) {
            return(J)
        }
        if (Jtype == 'r') {
            J %*% as.matrix(eseed)
        } else {
            as.matrix(eseedRev) %*% J
        }
    }
#    show(length(names(jacs)))
#    show(jacs)
    Jacs <- lapply(names(jacs), f)
    names(Jacs) <- names(jacs)

    if (!is.null(options$x_notAnalytic) && options$x_notAnalytic) {
        Jacs <- lapply(Jacs, Re)
    }
    
    dr <- diffMatrix(ress)
    dJ <- diffMatrix(Jacs)

    dr[is.nan(dr)] = 0
    dJ[is.nan(dJ)] = 0
    
#    show('dr')
#    show(dr)
#    show('dJ')
#    show(dJ)

    maxFErr = max(dr)
    maxErr = max(dJ)
    maxErrAD = max(dJ[1:2,1:2])
    
    cat(paste('(', sprintf('%.3g', maxErrAD), '/', sprintf('%.3g', maxErr), ')', sep='', collapse=''))
    
    errs <- list(J = maxErr, JAD = maxErrAD, f = maxFErr)

    if (!(maxFErr < 1e-13)) {
        show(ress)
    }
    expect_true(maxFErr < 1e-13)
    if (!(maxErr < 1e-5) || !(maxErrAD < 1e-13)) {
        show(jacs)
    }
    expect_true(maxErr < 1e-5)
    expect_true(maxErrAD < 1e-13)
    
    attr(errs, 'fres') <- ress
    attr(errs, 'Jacs') <- Jacs

    errs
}

adTest2 <- function(f, args, options = adrOptions()) {
    
    H <- adrHessRev(f, args, options = options)
    Hfd <- adrHessFD(f, args, options = options)
    
    ##    show(list(H=H, Hfd=Hfd))
    
    if (!is.null(options$x_notAnalytic) && options$x_notAnalytic) {
        H$H <- Re(H$H)
    }
    errH <- relmaxnorm(H$H, Hfd$H)
    errJ <- relmaxnorm(H$J, Hfd$J)
    errf <- relmaxnorm(H$f, Hfd$f)

    show(errl <- list(errH = errH, errJ = errJ, errf = errf))

    ##    show(dim(H$H))
    ##    show(dim(H$J))
    ##    show(dim(H$Jv))
    
    expect_true( identical ( dim(H$Jv), c(length(H$f), dim(H$J)[[2]]) ) )

    expect_true(errH < 1e-4)
    expect_true(errJ < 1e-6)
    expect_true(errf < 1e-12)

    list(errors=errl, H=H, Hfd=Hfd)
}


argsTest <- function(fs, args, options = adrOptions(trace=15), modes='frtd') {
    for (i in 1:length(fs)) {
        for (j in 1:length(args)) {
            show(list(i=i,j=j))
#            f <- function(x) { fs[[i]](x) }
            f <- fs[[i]]
            x <- args[[j]]
            adTest(f, if (is.list(x)) x else list(x), options = options, modes = modes)
        }
    }
}

argsTest2 <- function(fs, args, options = adrOptions()) {
    for (i in 1:length(fs)) {
        for (j in 1:length(args)) {
#            show(list(i=i,j=j))
#            f <- function(x) { fs[[i]](x) }
            f <- fs[[i]]
            x <- args[[j]]
            adTest2(f, list(x), options = options)
        }
    }
}

adr.bench <- function(handle, args, N = 3, NDD = 30, modes = 'frd', adopts.in = adrOptions(i = 1)) {

    z <- do.call(handle, args)
    
    nin <- numel(args[[adopts.in$independents]])
    nout <- numel(z)

#    show(list(adr.bench=1, nin=nin, nout= nout, N=N, NDD=NDD, modes=modes))
    
    Seed <- diag(1, nin, NDD)
    Seedv <- array(1, c(nin, 1))
    
    rhandle <- function() {
        do.call(handle, args)
    }
    funcTimes = bench(rhandle, N = N)
#    show('ft')
#    show(funcTimes)

    if (grepl('f', modes)) {
        adopts <- adopts.in

        adopts$vectormode = TRUE
        rhandle <- function() {
            adrDiffFor(handle, args, seed = Seed, options = adopts)
        }
        Jfor.v10 = bench(rhandle, N = N)
        rhandle <- function() {
            adrDiffFor(handle, args, seed = Seedv, options = adopts)
        }
        Jfor.v1 = bench(rhandle, N = N)

        adopts$vectormode = FALSE
        rhandle <- function() {
            adrDiffFor(handle, args, seed = Seedv, options = adopts)
        }
        Jfor.s = bench(rhandle, N = N)
    }

    if (grepl('r', modes)) {
        adopts <- adopts.in
        adopts$vectormode = TRUE
        adopts$functionResult = z

        rhandle <- function() {
            adrDiffRev(handle, args, seed = t(Seed), options = adopts)
        }
        Jrev.v10 = bench(rhandle, N = N)

        rhandle <- function() {
            adrDiffRev(handle, args, seed = t(Seedv), options = adopts)
        }
        Jrev.v1 = bench(rhandle, N = N)

        adopts$vectormode = FALSE
        rhandle <- function() {
            adrDiffRev(handle, args, seed = t(Seedv), options = adopts)
        }
        Jrev.s = bench(rhandle, N = N)
    }

    if (grepl('d', modes)) {
        adopts <- adopts.in

        rhandle <- function() {
            adrDiffFD(handle, args, seed = Seed, options = adopts)
        }
        Jfd.v10 = bench(rhandle, N = N)

        rhandle <- function() {
            adrDiffFD(handle, args, seed = Seedv, options = adopts)
        }
        Jfd.v1 = Jfd.s = bench(rhandle, N = N)
    }

    resFor <- cbind(Jfor.v10, Jfor.v1, Jfor.s)

    res <- rbind(resFor,
                 cbind(Jrev.v10, Jrev.v1, Jrev.s),
                 cbind(Jfd.v10, Jfd.v1, Jfd.s))
    dim(res) <- c(2, 3, 3)

    dimnames(res) <- list(x=c('mean', 'std'), y=c("adr.FM","adr.RM","FD"), z=c('v10', 'v1', 's'))
    
    attrs <- list()
    attrs['L'] <- N
    attrs['N'] <- nin
    attrs['M'] <- nout
    attrs['NDD'] <- NDD
    fdf <- funcTimes[,1]
#    show('fdf')
#    show(fdf)
    attrs['funcTimes'] <- data.frame(fdf)

    attr(res, 'tattr') <- attrs
    
    res
}


adr.nbench <- function(handle, initt, Ns) {
    nins <- zeros(safedim(Ns))
    resall <- array(0,c(0,0))
    resf <- array(0,c(0,0))
    for (k in 1:length(Ns)) {
        N <- Ns[[k]]
        args <- initt(N)
        x <- args[[1]]
        y <- args[[1]]
        nin <- numel(x)
        nins[[k]] <- nin
        cat(paste('size ', k, ' N = ', N, ' P = ', nin, '\n'))

        res <- adr.bench(handle, args)

#        show(res)
        
        resall <- as.array(c(resall, res))
        dim(resall) <- c(dim(res), k)
        dimnames(resall) <- dimnames(res)
        ft <- attr(res, 'tattr')$funcTimes
        resf <- as.array(c(resf, ft))
        dim(resf) <- c(safedim(ft), k)
    }

    attr(resall, 'tattr') <- list(Ns = Ns, Nins = nins, func = resf)
    
    resall
}
