
runScalar2ndOrderADTest <- function(f, x) {

    df <- d(f)

    adf <- adj(df, actlist = c(1,2))

    show(adf)
    
    n = 1

    x = matrix(16, n, 1)

    dx = matrix(0, n, 1)
    dx[[1]] <- 1

    args <- list(dx, x)
    
    ax = list(1, 0)

    adrGlobalADMode(0)

    dres <- df(list(dx), list(x))
    ares <- adf(ax, list(list(dx), list(x)))

    show(dres)
    show(ares)
    
    Hfd <- adrHessFD(f, list(x))
    show(list(Hfd=Hfd))

    err <- relmaxnorm(dres[[1]], Hfd$J)
    show(list(err = err))
    expect_true(err < 1e-5)

    err <- relmaxnorm(dres[[2]], f(x))
    show(list(err = err))
    expect_true(err < 1e-5)


    err <- relmaxnorm(ares$adj$fmtp0[[1]], Hfd$H)
    show(list(err = err))
    expect_true(err < 1e-3)

    err <- relmaxnorm(ares$adj$fmtp1[[1]], Hfd$J)
    show(list(err = err))
    expect_true(err < 1e-5)

    err <- relmaxnorm(ares$f[[1]], Hfd$J)
    show(list(err = err))
    expect_true(err < 1e-5)

    err <- relmaxnorm(ares$f[[2]], f(x))
    show(list(err = err))
    expect_true(err < 1e-5)

}

